/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_drm.h
 * $Revision: 1.6.2.1 $
 *----------------------------------------------------------------------------
 * Gart and DRM driver for Intel Embedded Graphics Driver
 * Copyright  2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/* Copyright 2003 - 2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _IEGD_DRM_H__
#define _IEGD_DRM_H__

#include "iegd_drm_client.h"

/* INTEL specific ioctls
 * The device specific ioctl range is 0x40 to 0x79.
 */

#define DRM_IOCTL_INTEL_GETPAGES         DRM_IOWR(DRM_BASE_COMMAND + \
				DRM_INTEL_GETPAGES, drm_intel_getpages_t)
#define DRM_IOCTL_INTEL_FREEPAGES         DRM_IOWR(DRM_BASE_COMMAND + \
				DRM_INTEL_FREEPAGES, drm_intel_freepages_t)
#define DRM_IOCTL_INTEL_INFO_INIT		DRM_IOW( DRM_BASE_COMMAND + \
				DRM_INTEL_INFO_INIT, intel_drm_info_t)
#define DRM_IOCTL_INTEL_INFO_GET		DRM_IOR( DRM_BASE_COMMAND + \
				DRM_INTEL_INFO_GET, intel_drm_info_t)
#define DRM_IOCTL_INTEL_INTERRUPT		DRM_IOWR( DRM_BASE_COMMAND + \
				DRM_INTEL_INTERRUPT, interrupt_info_t)

/* New ioctl to set kernel params:
 */
typedef struct drm_intel_listpages {
	int 		 pid;
	int 		 size;
	unsigned long phy_address;
	unsigned long virt_address;
	unsigned long offset;
} drm_intel_listpages_t;

typedef struct drm_intel_list{
	struct list_head head;
	drm_intel_listpages_t *page;
}drm_intel_list_t;
/*
 * This is the basic information structure that is obtained from the
 * IEGD XFree driver.
 */
typedef struct intel_device_private{
	drm_intel_list_t *pagelist;
	intel_drm_info_t *info_ptr;
	spinlock_t irqmask_lock;
	uint8_t *sgx_reg;
	uint8_t *vdc_reg;
	uint8_t *msvdx_reg;
	uint32_t sgx_irq_mask;
	uint32_t sgx_irq_mask2;
	uint32_t vdc_irq_mask;
	uint32_t msvdx_irq_mask;
	/* interrupt status bits returned once woken up */
	uint32_t interrupt_status;
	int irq_enabled;
	/* condition to wake up on */
	unsigned int event_present;
	wait_queue_head_t event_queue;
	/* interrupts that have already occured */
	unsigned int out_vdc;
	unsigned int out_sgx;
	unsigned int out_sgx2;
	unsigned int out_mtx;
} intel_device_private_t;

#endif /* _INTEL_DRM_H_ */

