/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_interface_2611.c
 * $Revision: 1.6 $
 *----------------------------------------------------------------------------
 * Gart and DRM driver for Intel Embedded Graphics Driver
 * Copyright  2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/* Copyright 2003 - 2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "iegd.h"
#include "drmP.h"
#include "drm.h"

#include "iegd_drm.h"
#include "iegd_drv.h"

#if KERNEL2611
int intel_postinit_2611(struct drm_device *dev,unsigned long flags){

	intel_device_private_t *priv;
	priv=(intel_device_private_t *)dev->dev_private;

	intel_postinit(&priv);
	dev->dev_private=priv;

	return 0;

}

void intel_prerelease_2611(drm_device_t *dev,DRMFILE filp){

	intel_prerelease(dev);

}

int intel_getpages_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_getpages(dev,filp,arg);

}

int intel_freepages_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_freepages(dev,arg);
}

int intel_drm_info_init_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_drm_info_init(dev,arg);

}

int intel_drm_info_get_2611( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_drm_info_get(dev,arg);

}

/* Following 2 functions were taken from drm_memory.c 
 * For some reason they are not being exported to use
 * by the other drm.
 */

/**
 * Allocate pages.
 *
 * \param order size order.
 * \param area memory area. (Not used.)
 * \return page address on success, or zero on failure.
 *
 * Allocate and reserve free pages.
 */
unsigned long intel_alloc_pages(int order, int area)
{
	unsigned long address;
	unsigned long bytes	  = PAGE_SIZE << order;
	unsigned long addr;
	unsigned int  sz;

	address = __get_free_pages(GFP_KERNEL, order);
	if (!address) 
		return 0;

				/* Zero */
	memset((void *)address, 0, bytes);

				/* Reserve */
	for (addr = address, sz = bytes;
	     sz > 0;
	     addr += PAGE_SIZE, sz -= PAGE_SIZE) {
		SetPageReserved(virt_to_page(addr));
	}

	return address;
}

/**
 * Free pages.
 * 
 * \param address address of the pages to free.
 * \param order size order.
 * \param area memory area. (Not used.)
 *
 * Unreserve and free pages allocated by alloc_pages().
 */
void intel_free_pages(unsigned long address, int order, int area)
{
	unsigned long bytes = PAGE_SIZE << order;
	unsigned long addr;
	unsigned int  sz;

	if (!address) 
		return;

	/* Unreserve */
	for (addr = address, sz = bytes;
	     sz > 0;
	     addr += PAGE_SIZE, sz -= PAGE_SIZE) {
		ClearPageReserved(virt_to_page(addr));
	}

	free_pages(address, order);
}

drm_ioctl_desc_t intel_ioctls[]={					 
	[DRM_IOCTL_NR(DRM_INTEL_GETPAGES)] = { intel_getpages_2611,  0,0 }, 
	[DRM_IOCTL_NR(DRM_INTEL_FREEPAGES)] = { intel_freepages_2611, 0,0 },
	[DRM_IOCTL_NR(DRM_INTEL_INFO_INIT)] = { intel_drm_info_init_2611, 0,0 },
	[DRM_IOCTL_NR(DRM_INTEL_INFO_GET)] = { intel_drm_info_get_2611,  0,0 }   
};

int intel_max_ioctl = DRM_ARRAY_SIZE(intel_ioctls);


static int version( drm_version_t *version )
{
	int len;

	version->version_major = DRIVER_MAJOR;
	version->version_minor = DRIVER_MINOR;
	version->version_patchlevel = DRIVER_PATCHLEVEL;
	DRM_COPY( version->name, DRIVER_NAME );
	DRM_COPY( version->date, DRIVER_DATE );
	DRM_COPY( version->desc, DRIVER_DESC );
	return 0;
}

static struct pci_device_id pciidlist[] = {
	INTEL_PCI_IDS
};

static struct drm_driver driver = {
	.driver_features = DRIVER_USE_AGP|DRIVER_REQUIRE_AGP|DRIVER_USE_MTRR,
	.prerelease = intel_prerelease_2611,
	.postinit =intel_postinit_2611,
	.reclaim_buffers=drm_core_reclaim_buffers,
	.get_map_ofs=drm_core_get_map_ofs,
	.get_reg_ofs=drm_core_get_reg_ofs,
	.version = version,
	.ioctls = intel_ioctls,
	.fops = {
		.owner = THIS_MODULE,
		.open = drm_open,
		.release = drm_release,
		.ioctl = drm_ioctl,
		.mmap = drm_mmap,
		.poll = drm_poll,
		.fasync = drm_fasync,
	},
	.pci_driver = {
		.name          = DRIVER_NAME,
		.id_table      = pciidlist,
	}
};

int __init intel_init(void)
{
	driver.num_ioctls = intel_max_ioctl;
	return drm_init(&driver);
}

void __exit intel_exit(void)
{
	drm_exit(&driver);
}

struct file_operations intel_buffer_fops = {
	.open	 = drm_open,
	.flush	 = drm_flush,
	.release = drm_release,
	.ioctl	 = drm_ioctl,
	.mmap	 = intel_mmap_buffers,
	.fasync  = drm_fasync,
};
#endif
