/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: myclient.c
 * $Revision: 1.5 $
 *----------------------------------------------------------------------------
 * DRM test program
 * Copyright  2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/* Copyright 2003 - 2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*client to test the ioctl
 * make sure you change the permission bits in intel.h to 0,0 
 * before you start using this
 */

#include "iegd.h"

#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <stdio.h>

#define DRM_IOCTL_BASE			'd'
#define DRM_IO(nr)			_IO(DRM_IOCTL_BASE,nr)
#define DRM_IOR(nr,type)		_IOR(DRM_IOCTL_BASE,nr,type)
#define DRM_IOW(nr,type)		_IOW(DRM_IOCTL_BASE,nr,type)
#define DRM_IOWR(nr,type)		_IOWR(DRM_IOCTL_BASE,nr,type)

#include "intel_drm_client.h"

#define DRM_IOCTL_INTEL_GETPAGES         DRM_IOWR(DRM_BASE_COMMAND + \
				DRM_INTEL_GETPAGES, drm_intel_getpages_t)
#define DRM_IOCTL_INTEL_FREEPAGES         DRM_IOWR(DRM_BASE_COMMAND + \
				DRM_INTEL_FREEPAGES, drm_intel_freepages_t)
#define DRM_IOCTL_INTEL_INFO_INIT		DRM_IOW( DRM_BASE_COMMAND + \
				DRM_INTEL_INFO_INIT, intel_drm_info_t)
#define DRM_IOCTL_INTEL_INFO_GET		DRM_IOR( DRM_BASE_COMMAND + \
				DRM_INTEL_INFO_GET, intel_drm_info_t)


#define PAGE_SIZE 4096
int main()
{
int file_desc, ret_value;
printf("ytay starting client\n");
/* Open the drm */
file_desc=open("/dev/dri/card0",O_RDWR);

if(file_desc<0){
/* probably Suse distro since the dev tree is different.
 * try /dev/card0
 */
file_desc=open("/dev/card0",O_RDWR);

}

if(file_desc<0){

printf("ytay can't open device file:%s\n",DRIVER_DESC);
	exit(-1);
}

printf("ytay open device file:%d\n",file_desc);
drm_intel_getpages_t getpages;
/* set the number of bytes we want the drm to allocate */
getpages.size=(PAGE_SIZE- 1000); 

ret_value=ioctl(file_desc,DRM_IOCTL_INTEL_GETPAGES,&getpages);
if(ret_value<0){
printf("ytay ioctl failed!\n");
	exit(-1);
}
printf("ytay ioctl success\n");
printf("ytay size%d,phy_address:%#x,virt_address:%#x,offset:%#x\n",getpages.size,getpages.phy_address,getpages.virt_address,getpages.offset);

/* test for memory access */

int i;
unsigned long *virt_ptr;

virt_ptr=(unsigned long *)getpages.virt_address;

/* input 0..10 into subsequent memory */

for(i=0;i<=11;i++){
*virt_ptr=i;
virt_ptr++;

}

/*read from subsequent memory */

virt_ptr=(unsigned long *)getpages.virt_address;
for(i=0;i<=15;i++){
printf("virt_ptr@%#x,value:%d\n",virt_ptr,*virt_ptr);
virt_ptr++;
}
/* set the number of bytes we want the drm to allocate */
getpages.size=(PAGE_SIZE- 1000); 

ret_value=ioctl(file_desc,DRM_IOCTL_INTEL_GETPAGES,&getpages);
if(ret_value<0){
printf("ytay ioctl failed!\n");
	exit(-1);
}
printf("ytay ioctl success\n");
printf("ytay size%d,phy_address:%#x,virt_address:%#x,offset:%#x\n",getpages.size,getpages.phy_address,getpages.virt_address,getpages.offset);


/* freeing memory */

drm_intel_freepages_t freepages;
freepages.size=getpages.size;
freepages.phy_address=getpages.phy_address;
freepages.virt_address=getpages.virt_address;
printf("ytay freeing phy_address:%#x,size:%#x\n",freepages.phy_address,freepages.size);
/*
ioctl(file_desc,DRM_IOCTL_INTEL_FREEPAGES,&freepages);
*/
/* init the drm info structure in the drm and test its value */

 intel_drm_info_t info;
 intel_drm_info_t test_info;
 info.device_id=0x456;
 info.revision=333;
 info.video_memory_offset=0x10245;
 info.video_memory_size=987;
 info.hw_status_offset=0x444;

 printf("Testing init info device_id:%#x,revision:%d,offset:%#x,size:%d,hw_status_offset:%lx\n",
	info.device_id,info.revision,info.video_memory_offset,info.video_memory_size,info.hw_status_offset);
 
 ioctl(file_desc,DRM_IOCTL_INTEL_INFO_INIT,&info);

/* init the drm info structure in the drm and test its value */

 info.device_id=0x123;
 info.revision=456;
 info.video_memory_offset=0x789;
 info.video_memory_size=111;
 info.hw_status_offset=0x555;

 printf("Testing init 2nd info device_id:%#x,revision:%d,offset:%#x,size:%d,hw_status_offset:%lx\n",
	info.device_id,info.revision,info.video_memory_offset,info.video_memory_size,info.hw_status_offset);
 
 ioctl(file_desc,DRM_IOCTL_INTEL_INFO_INIT,&info);

 printf("Testing init 2nd info device_id:%#x,revision:%d,offset:%#x,size:%d,hw_status_offset:%lx\n",
	info.device_id,info.revision,info.video_memory_offset,info.video_memory_size,info.hw_status_offset);
 
 ioctl(file_desc,DRM_IOCTL_INTEL_INFO_INIT,&info);



 ioctl(file_desc,DRM_IOCTL_INTEL_INFO_GET,&test_info);

 printf("Got init info device_id:%#x,revision:%d,offset:%#x,size:%d,hw_status_offset:%lx\n",
	test_info.device_id,test_info.revision,test_info.video_memory_offset,test_info.video_memory_size,test_info.hw_status_offset);


close(file_desc);
/*
sleep(100000000000);
*/
return 0;

}
