/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: igd_gart.h
 * $Revision: 1.10 $
 *----------------------------------------------------------------------------
 * <>
 * Copyright  2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *
 *----------------------------------------------------------------------------
 * Functions:
 *
 *
 *----------------------------------------------------------------------------
 */

#ifndef _INIT_GART_DISPATCH
#define _INIT_GART_DISPATCH

#include <linux/pci.h>
#include <linux/agp_backend.h>
#include "agp.h"

typedef struct agp_bridge_driver bridge_driver_t;
typedef struct agp_bridge_data bridge_data_t;

/* Dispatch table that contained information about
 * specific chipset */
typedef struct _gart_dispatch {
	unsigned short vendor_id;
	unsigned short bridge_id;    /* Bridge device id */
	unsigned short device_id;    /* chipset id */
	char *name;                  /* Name for the chipset */
	unsigned short dev_flag;
	struct pci_driver *old_gart; /* old gart info */
	struct pci_dev *bridge_pdev; /* Bridge device info */
	bridge_data_t *bridge_info;  /* bridge information for gart */
}gart_dispatch_t;

/* Structure that keep the private data for chipset */
typedef struct _dev_private_data {
	struct pci_dev *pdev;
	volatile u8 __iomem *registers;
	volatile u32 __iomem *gtt;
	union {
		int num_dcache_entries;
		int gtt_entries;
	};
	u32 pm_save[16]; /* PCI config saved here on suspend/resume. */
			 /* Required for older kernel versions. */
	int split_gtt;
	volatile u32 __iomem *upper_gtt;
}dev_private_data_t;

/* Dispatch table for function hook */
typedef struct _dispatch_table {
	unsigned short did;
	void *table;
}dispatch_table_t;

/* Table contained function pointer for specific chipset */
typedef struct _driver_func_table {
	bridge_driver_t driver_func; /* Contained actual function */
	void (*config_private)(void);    /* config private */
}driver_func_table_t;


#endif
