#!/bin/bash

#  -*- pse-c -*-
#----------------------------------------------------------------------------
# Filename: install.sh
# $Revision: 1.20 $
#----------------------------------------------------------------------------
# <>
# Copyright © 2008, Intel Corporation.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms and conditions of the GNU General Public License,
# version 2, as published by the Free Software Foundation.
#
# This program is distributed in the hope it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 
# 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
#
#
#----------------------------------------------------------------------------
#

INSTOPT=${KERNELDIR:+xxx};
KERNELDIR=${KERNELDIR:-/lib/modules/$(uname -r)}
VERSION=/include/linux/version.h
INSTALLDIR=${KERNELDIR}/kernel/drivers/char/agp
MAKEFILE="Makefile"
DEPMOD=$(whereis depmod | awk '{print $2}')
ISSUEFILE=/etc/issue


# Function to create makefile.
#
# The build system for kernel 2.6.24 doesn't allow CFLAGS to be modified
# from the default, need to use EXTRA_CFLAGS instead.  However, will this
# work for older kernels?
create_make_file()
{
	if [[ $VERCODE -le 132631 ]]; then
cat > $MAKEFILE <<'IEGDMAKEFILE'
KERNELVER ?= $(shell uname -r)
KERNELDIR ?= /lib/modules/$(KERNELVER)/build
INSTALLDIR ?= installdir
PWD ?= $(shell pwd)

CFLAGS += -I$(PWD)/include
CFLAGS += -I$(PWD)/val/agp/agpversion -I$(PWD)/val/drm/drmversion DEBUG_FLAG

all: clean modules

modules:
		@echo $(PWD)
		@$(MAKE) -C $(KERNELDIR) M=$(PWD) modules

install:
		install -o root -g root -m 755 -d $(INSTALLDIR)
		install -o root -g root -m 744 iegd_mod.ko $(INSTALLDIR)
		/sbin/depmod -a

uninstall:
		rm -rf $(INSTALLDIR)/iegd_mod.ko
		/sbin/depmod -a

clean:
		@rm -f *.o iegd*.ko iegd*.mod.c iegd*.o agp/*.o drm/*.o Module.symvers
		@rm -fr .intel* .tmp* .*.cmd agp/.*.cmd drm/.*.cmd

obj-m := iegd_mod.o
iegd_mod-objs := agp/pci.o agp/global.o agp/drv_alm.o agp/drv_nap.o agp/drv_plb.o agp/drv_cmn.o agp/drv_gn4.o drm/iegd_drv.o drm/iegd_interface.o drm/iegd_interface_265.o drm/iegd_interface_2611.o drm/iegd_interface_2615.o drm/iegd_interface_2624.o drm/psb_irq.o

IEGDMAKEFILE
else
cat > $MAKEFILE <<'IEGDMAKEFILE'
KERNELVER ?= $(shell uname -r)
KERNELDIR ?= /lib/modules/$(KERNELVER)/build
INSTALLDIR ?= installdir
PWD ?= $(shell pwd)

EXTRA_CFLAGS += -I$(PWD)/include
EXTRA_CFLAGS += -I$(PWD)/val/agp/agpversion -I$(PWD)/val/drm/drmversion DEBUG_FLAG

all: clean modules

modules:
		@echo $(PWD)
		@$(MAKE) -C $(KERNELDIR) M=$(PWD) modules

install:
		install -o root -g root -m 755 -d $(INSTALLDIR)
		install -o root -g root -m 744 iegd_mod.ko $(INSTALLDIR)
		/sbin/depmod -a

uninstall:
		rm -rf $(INSTALLDIR)/iegd_mod.ko
		/sbin/depmod -a

clean:
		@rm -f *.o iegd*.ko iegd*.mod.c iegd*.o agp/*.o drm/*.o Module.symvers
		@rm -fr .intel* .tmp* .*.cmd agp/.*.cmd drm/.*.cmd

obj-m := iegd_mod.o
iegd_mod-objs := agp/pci.o agp/global.o agp/drv_alm.o agp/drv_nap.o agp/drv_plb.o agp/drv_cmn.o agp/drv_gn4.o drm/iegd_drv.o drm/iegd_interface.o drm/iegd_interface_265.o drm/iegd_interface_2611.o drm/iegd_interface_2615.o drm/iegd_interface_2624.o drm/psb_irq.o 

IEGDMAKEFILE
fi

}

# Function to uninstall IKM
uninstall_iegd_mod()
{
	if [ ! -f $MAKEFILE ]
	then
		create_make_file
	fi

	echo -e "\n\nUninstalling IEGD kernel module"

	if [[ ! -w "$INSTALLDIR" && $(id -u) -ne 0 ]]
	then
		echo -e "\n\033[1m$INSTALLDIR is not accessible"
		while [[ "$answer" != "Y" || "$answer" != "y" || "$answer" != "N" || "$answer" != "n" ]]
		do
			echo -ne "\033[51mSwitch to user root? [y/n] \033[0m"
			read answer
			case "$answer" in

				"Y" | "y")

				su -c "make -f $MAKEFILE uninstall"

				if [ "$?" -ne "0" ]
				then
					continue
				else
					break
				fi
				;;

				"N" | "n")
				echo "Uninstallation process of IKM is been cancelled"
				exit 1
				;;

				*)
				echo "Invalid option... Try again?"
				continue
				;;

			esac
		done
	else
		make -f $MAKEFILE uninstall
	fi
	
	echo "Uninstallation complete"
}

argument=$(echo $1 | tr [A-Z] [a-z])

if [ "$argument" = "uninstall" ]
then
	uninstall_iegd_mod
	exit
fi

#
# Crazy hack to make this work with the RedHat Embedded for Menlow version
# of the 2.6.23 kernel.
#
if [ "$argument" = "rhe" ]
then
	echo "Configure source for RedHat Embedded"
	/bin/cp drm/iegd_drv.h drm/iegd_drv.tmp
	# For work around to support RHE after RH use old drm package for drm
	sed -e '/LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,23)/ c#if 0' <  drm/iegd_drv.tmp > drm/iegd_drv.h
	xdrmversion="drmv11p0"
else
	xdrmversion="drmv13p0"
fi


if [ -f ${KERNELDIR}${VERSION} ]; then
	BUILDDIR=${KERNELDIR}
elif [ -f ${KERNELDIR}/build${VERSION} ]; then
	BUILDDIR=${KERNELDIR}/build
else

cat <<EOF

Could not locate your kernel header files.  Please install the kernel-devel
package for your distribution of Linux, or set the KERNELDIR environment
variable to the directory containing your target kernel source tree.

EOF

	exit
fi

VERCODE=`cat ${BUILDDIR}${VERSION} | grep LINUX_VERSION_CODE | awk '{print $3}'`
MAJOR=$((($VERCODE >> 16) & 0xFF))
MINOR=$((($VERCODE >> 8) & 0xFF))
RELEASE=$(($VERCODE & 0xFF))

cat <<EOF

Found kernel header files in ${BUILDDIR}

Building for kernel ${MAJOR}.${MINOR}.${RELEASE}

If this is not the kernel you wish to build for, please set the KERNELDIR
environment variable to the directory containing your target kernel
source tree.

EOF
sleep 5

if [ ! -f $BUILDDIR/include/linux/config.h ]
then
	echo "Creating config.h file"
	touch $BUILDDIR/include/linux/config.h
fi

#Detecting agp release version
if [[ $VERCODE -le 132619 ]]; then
	agpversion="agpm0v100"
elif [[ $VERCODE -le 132628 ]]; then
	agpversion="agpm0v101"
elif [[ $VERCODE -ge 132629 ]]; then
	agpversion="agpm0v102"
else
	echo "Unsupported kernel version."
	exit 1;
fi

#Detecting DRM version
if [[ $VERCODE -le 132618 ]]; then
	drmversion="drmv00p0"
elif [[ $VERCODE -ge 132619 && $VERCODE -le 132623 ]]; then

	# FC5 does not use the drm from the generic kernel
	fedora_version=`cat ${ISSUEFILE} | grep -i fedora | awk '{print $4}'`
	if [[ "$fedora_version" = "5" ]]; then
		drmversion="drmv10p1"
	else
		drmversion="drmv10p0"
	fi

elif [[ $VERCODE -ge 132624 && $VERCODE -le 132627 ]]; then
	drmversion="drmv10p1"
elif [[ $VERCODE -ge 132628 && $VERCODE -le 132629 ]]; then
	drmversion="drmv11p0"
elif [[ $VERCODE -eq 132630 ]]; then
	fedora_version=`cat ${ISSUEFILE} | grep -i fedora | awk '{print $1}'`
	if [[ "$fedora_version" = "Fedora" ]]; then
		drmversion="drmv13p0"
	else
		drmversion="drmv12p0"
	fi
elif [[ $VERCODE -eq 132631 ]]; then
		drmversion=$xdrmversion
elif [[ $VERCODE -ge 132632 ]]; then
		drmversion="drmv14p0"
else
	echo "Unsupported kernel version."
	exit 1;
fi


# Call routine to create makefile
create_make_file

if [ -f "$MAKEFILE" ]
then
	# If install.sh invoke with the debug argument set
	# the debug flag in the makefile
	if [ "$argument" = "debug" ] ; then
		DEBUG="-DCONFIG_AGP_DEBUG"
	fi
	sed -i "s/DEBUG_FLAG/$DEBUG/g" $MAKEFILE
	sed -i "s/agpversion/$agpversion/g" $MAKEFILE
	sed -i "s/drmversion/$drmversion/g" $MAKEFILE
	sed -i "s|installdir|$INSTALLDIR|g" $MAKEFILE

else
	echo "Makefile creation error"
	exit 1
fi

if ! make -f $MAKEFILE
then
	echo "Make error:"
	exit 1
fi

if [[ "$INSTOPT" = "xxx" ]]; then
	exit
fi

echo -e "\n\nThis will install the module to the $INSTALLDIR. "

if [[ ! -w "$INSTALLDIR" && $(id -u) -ne 0 ]]
then
	echo -e "\n\n\033[1m$INSTALLDIR is not accessible"
	while [[ "$answer" != "Y" || "$answer" != "y" || "$answer" != "N" || "$answer" != "n" ]]
	do
		echo -ne "\033[51mSwitch to user root? [y/n] \033[0m"
		read answer
		case "$answer" in

			"Y" | "y")

			su -c "make -f $MAKEFILE install"

			if [ "$?" -ne "0" ]
			then
				continue
			else
				break
			fi
			;;

			"N" | "n")
			echo "iegd_mod.ko has not been installed in $INSTALLDIR"
			exit 1
			;;

			*)
			echo "Invalid option... Try again?"
			continue
			;;

		esac
	done
else
	msg="Is this ok? [y/n]"

	while [[ "$answer" != "Y" || "$answer" != "y" || "$answer" != "N" || "$answer" != "n" ]]
	do
		echo -ne "\033[51m$msg \033[0m"
		read answer
		case "$answer" in

			"Y" | "y")

			su -c "make -f $MAKEFILE install"

			if [ "$?" -ne "0" ]
			then
				continue
			else
				break
			fi
			;;

			"N" | "n")
			echo "iegd_mod.ko has not been installed in $INSTALLDIR"
			exit 1
			;;

			*)
			msg="Invalid option... Try again?[y/n]"
			continue
			;;

		esac
	done
fi

if [ "$argument" = "rhe" ]
then
	# fix changes make to the source for rhe
	/bin/cp drm/iegd_drv.h drm/iegd_drv.tmp
	sed -e '/typedef struct drm_ioctl_desc drm_ioctl_desc_t;/ c\typedef struct drm_ioctl_desc drm_ioctl_desc_t;' < drm/iegd_drv.tmp > drm/iegd_drv.h
fi

echo "Installation complete"

