/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

    Module Name:
    ap.h

    Abstract:
    Miniport generic portion header file

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
    Paul Lin    08-01-2002    created
    James Tan   09-06-2002    modified (Revise NTCRegTable)
    John Chang  12-22-2004    modified for RT2561/2661. merge with STA driver
*/
#ifndef __AP_H__
#define __AP_H__



// ========================= AP RTMP.h ================================



// =============================================================
//      Function Prototypes
// =============================================================

// ap_data.c

BOOLEAN APBridgeToWdsAndWirelessSta(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pHeader,
    IN  UINT            HdrLen,
    IN  PUCHAR          pData,
    IN  UINT            DataLen,
    IN  ULONG           fromwdsidx);

/*VOID    APHandleRxDoneInterrupt(
    IN  PRTMP_ADAPTER   pAd);*/

VOID	APSendPackets(
	IN	NDIS_HANDLE		MiniportAdapterContext,
	IN	PPNDIS_PACKET	ppPacketArray,
	IN	UINT			NumberOfPackets);

NDIS_STATUS APSendPacket(
    IN  PRTMP_ADAPTER   pAd,
    IN  PNDIS_PACKET    pPacket);

NDIS_STATUS APHardTransmit(
    IN  PRTMP_ADAPTER pAd,
    IN  PNDIS_PACKET   pPacket,
    IN  UCHAR			NumberRequired,
    IN  UCHAR               QueIndx);


VOID APFindEncryptKey(
    IN PRTMP_ADAPTER pAd,
    IN UCHAR         WdsOrAid,
    IN BOOLEAN       bEapol,
    IN BOOLEAN       bMulticast,
    OUT PUCHAR       pCipherAlg,
    OUT PUCHAR       pKeyTable,
    OUT PUCHAR       pKeyIdx,
    OUT PCIPHER_KEY  *ppCipherKey);

NDIS_STATUS APCheckRxError(
    IN  PRXD_STRUC pRxD);

BOOLEAN APCheckClass2Class3Error(
    IN  PRTMP_ADAPTER   pAd,
    IN  PHEADER_802_11  pHeader);

VOID APHandleRxPsPoll(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr,
    IN  USHORT          Aid,
    IN  BOOLEAN			isActive);

VOID    RTMPDescriptorEndianChange(
    IN  PUCHAR          pData,
    IN  ULONG           DescriptorType);

VOID    RTMPFrameEndianChange(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pData,
    IN  ULONG           Dir,
    IN  BOOLEAN         FromRxDoneInt);

// ap_assoc.c

VOID APAssocStateMachineInit(
    IN  PRTMP_ADAPTER   pAd,
    IN  STATE_MACHINE *S,
    OUT STATE_MACHINE_FUNC Trans[]);

VOID  APPeerAssocReqAction(
    IN  PRTMP_ADAPTER   pAd,
    IN  MLME_QUEUE_ELEM *Elem);

VOID  APPeerReassocReqAction(
    IN  PRTMP_ADAPTER   pAd,
    IN  MLME_QUEUE_ELEM *Elem);

VOID  APPeerDisassocReqAction(
    IN  PRTMP_ADAPTER   pAd,
    IN  MLME_QUEUE_ELEM *Elem);

VOID APMlmeDisassocReqAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID  APCls3errAction(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR pAddr);

USHORT APAssignAid(
    IN PRTMP_ADAPTER pAd,
    IN PMAC_TABLE_ENTRY pMacEntry);

USHORT APBuildAssociation(
    IN PRTMP_ADAPTER pAd,
    IN PUCHAR pAddr,
    IN USHORT CapabilityInfo,
    IN UCHAR  MaxSupportedRateIn500Kbps,
    IN UCHAR  *RSN,
    IN UCHAR  *pRSNLen,
    IN BOOLEAN bWmmCapable,
    IN ULONG  RalinkIe,
    OUT USHORT *pAid);

// ap_auth.c

void APAuthStateMachineInit(
    IN PRTMP_ADAPTER pAd,
    IN STATE_MACHINE *Sm,
    OUT STATE_MACHINE_FUNC Trans[]);

VOID APMlmeDeauthReqAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID APCls2errAction(
    IN PRTMP_ADAPTER pAd,
    IN PUCHAR pAddr);

// ap_authrsp.c

VOID APAuthRspStateMachineInit(
    IN PRTMP_ADAPTER pAd,
    IN PSTATE_MACHINE Sm,
    IN STATE_MACHINE_FUNC Trans[]);

VOID APPeerAuthAtAuthRspIdleAction(
    IN  PRTMP_ADAPTER   pAd,
    IN  MLME_QUEUE_ELEM *Elem);

#ifdef WIN_NDIS
VOID APPeerDeauthReqAction(
    IN VOID *Adaptor,
    IN MLME_QUEUE_ELEM *Elem);
#else
VOID APPeerDeauthReqAction(
    IN PRTMP_ADAPTER pAd,
    IN PMLME_QUEUE_ELEM Elem);
#endif

VOID APPeerAuthSimpleRspGenAndSend(
    IN  PRTMP_ADAPTER   pAd,
    IN  PHEADER_802_11 pHdr80211,
    IN  USHORT Alg,
    IN  USHORT Seq,
    IN  USHORT StatusCode);

// ap_connect.c

VOID APMakeBssBeacon(
    IN  PRTMP_ADAPTER   pAd);

VOID  APUpdateBeaconFrame(
    IN  PRTMP_ADAPTER   pAd);

// ap_sync.c

VOID APSyncStateMachineInit(
    IN PRTMP_ADAPTER pAd,
    IN STATE_MACHINE *Sm,
    OUT STATE_MACHINE_FUNC Trans[]);

VOID APPeerProbeReqAction(
    IN  PRTMP_ADAPTER pAd,
    IN  MLME_QUEUE_ELEM *Elem);

VOID APPeerBeaconAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

// ap_wpa.c

VOID APWpaStateMachineInit(
    IN  PRTMP_ADAPTER   pAd,
    IN  STATE_MACHINE *Sm,
    OUT STATE_MACHINE_FUNC Trans[]);

// ap_mlme.c

VOID APMlmePeriodicExec(
    IN  PRTMP_ADAPTER   pAd);

VOID APMlmeDynamicTxRateSwitching(
    IN PRTMP_ADAPTER pAd);

BOOLEAN APMsgTypeSubst(
    IN PRTMP_ADAPTER pAd,
    IN PFRAME_802_11 pFrame,
    OUT INT *Machine,
    OUT INT *MsgType);

VOID APQuickResponeForRateUpExec(
    IN PVOID SystemSpecific1,
    IN PVOID FunctionContext,
    IN PVOID SystemSpecific2,
    IN PVOID SystemSpecific3);

VOID BeaconPeriodicExec(
    IN PVOID SystemSpecific1,
    IN PVOID FunctionContext,
    IN PVOID SystemSpecific2,
    IN PVOID SystemSpecific3);


// ap.c

NDIS_STATUS APInitialize(
    IN  PRTMP_ADAPTER   pAd);

VOID APShutdown(
    IN PRTMP_ADAPTER    pAd);

VOID APStartUp(
    IN  PRTMP_ADAPTER   pAd);

VOID APStop(
    IN  PRTMP_ADAPTER   pAd);

VOID APCleanupPsQueue(
    IN  PRTMP_ADAPTER   pAd,
    IN  PQUEUE_HEADER   pQueue);

VOID MacTableReset(
    IN  PRTMP_ADAPTER   pAd);

MAC_TABLE_ENTRY *MacTableInsertEntry(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr);

BOOLEAN MacTableDeleteEntry(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr);

MAC_TABLE_ENTRY *MacTableLookup(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr);

VOID MacTableMaintenance(
    IN PRTMP_ADAPTER pAd);

WDS_ENTRY *WdsTableInsertEntry(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr,
    IN  ULONG           index);

BOOLEAN WdsTableDeleteEntry(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr,
    IN  ULONG           index);

WDS_ENTRY *WdsTableLookup(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr,
    IN  ULONG           index);

VOID WdsTableMaintenance(
    IN PRTMP_ADAPTER    pAd);

MAC_TABLE_ENTRY *APSsPsInquiry(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr,
    OUT SST             *Sst,
    OUT USHORT          *Aid,
    OUT UCHAR           *PsMode,
    OUT UCHAR           *Rate);

BOOLEAN APPsIndicate(
    IN  PRTMP_ADAPTER   pAd,
    IN  PUCHAR          pAddr,
    IN  UCHAR           Rssi,
    IN  UCHAR           Psm);

VOID ApLogEvent(
    IN PRTMP_ADAPTER    pAd,
    IN PUCHAR           pAddr,
    IN USHORT           Event);

VOID APUpdateCapabilityAndErpIe(
    IN PRTMP_ADAPTER pAd);

BOOLEAN ApCheckAccessControlList(
    IN PRTMP_ADAPTER pAd,
    IN PUCHAR        pAddr);

VOID ApUpdateAccessControlList(
    IN PRTMP_ADAPTER pAd);

VOID ApEnqueueNullFrame(
    IN PRTMP_ADAPTER pAd,
    IN PUCHAR        pAddr,
    IN UCHAR         TxRate,
    IN UCHAR         PID);

VOID ApSendFrame(
    IN  PRTMP_ADAPTER   pAd,
    IN  PVOID           pBuffer,
    IN  ULONG           Length,
    IN  UCHAR           TxRate,
    IN  UCHAR           PID);

VOID ApEnqueueAckFrame(
    IN PRTMP_ADAPTER pAd,
    IN PUCHAR        pAddr,
    IN UCHAR         TxRate);

UCHAR APAutoSelectChannel(
    IN PRTMP_ADAPTER    pAd);

// ap_sanity.c

BOOLEAN PeerAssocReqSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pAddr2,
    OUT USHORT *pCapabilityInfo,
    OUT USHORT *pListenInterval,
    OUT UCHAR *pSsidLen,
    OUT char *Ssid,
    OUT UCHAR *pRatesLen,
    OUT UCHAR Rates[],
    OUT UCHAR *RSN,
    OUT UCHAR *pRSNLen,
    OUT BOOLEAN *pbWmmCapable,
    OUT ULONG  *pRalinkIe);

BOOLEAN PeerReassocReqSanity(
    IN  PRTMP_ADAPTER   pAd,
    IN  VOID *Msg,
    IN  ULONG MsgLen,
    OUT PUCHAR pAddr2,
    OUT USHORT *pCapabilityInfo,
    OUT USHORT *pListenInterval,
    OUT PUCHAR pApAddr,
    OUT UCHAR *pSsidLen,
    OUT char *Ssid,
    OUT UCHAR *pRatesLen,
    OUT UCHAR Rates[],
    OUT UCHAR *RSN,
    OUT UCHAR *pRSNLen,
    OUT BOOLEAN *pbWmmCapable,
    OUT ULONG  *pRalinkIe);

BOOLEAN PeerDisassocReqSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pAddr2,
    OUT USHORT *Reason);

BOOLEAN PeerDeauthReqSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pAddr2,
    OUT USHORT *Reason);

BOOLEAN APPeerAuthSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pAddr,
    OUT USHORT *Alg,
    OUT USHORT *Seq,
    OUT USHORT *Status,
    CHAR *ChlgText);

BOOLEAN APPeerProbeReqSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pAddr2,
    OUT CHAR Ssid[],
    OUT UCHAR *SsidLen);

BOOLEAN APPeerBeaconAndProbeRspSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pAddr2,
    OUT PUCHAR pBssid,
    OUT CHAR Ssid[],
    OUT UCHAR *SsidLen,
    OUT UCHAR *BssType,
    OUT USHORT *BeaconPeriod,
    OUT UCHAR *Channel,
    OUT LARGE_INTEGER *Timestamp,
    OUT USHORT *CapabilityInfo,
    OUT UCHAR Rate[],
    OUT UCHAR *RateLen,
    OUT BOOLEAN *ExtendedRateIeExist,
    OUT UCHAR *Erp);

// ap_info.c

NDIS_STATUS APQueryInformation(
    IN  NDIS_HANDLE MiniportAdapterContext,
    IN  NDIS_OID    Oid,
    IN  PVOID       pInformationBuffer,
    IN  ULONG       InformationBufferLength,
    OUT PULONG      pBytesWritten,
    OUT PULONG      pBytesNeeded);

NDIS_STATUS APSetInformation(
    IN  NDIS_HANDLE MiniportAdapterContext,
    IN  NDIS_OID    Oid,
    IN  PVOID       pInformationBuffer,
    IN  ULONG       InformationBufferLength,
    OUT PULONG      pBytesRead,
    OUT PULONG      pBytesNeeded);


// ================== end of AP RTMP.h ========================

#endif  // __AP_H__

