/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2005, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	rtmp_info.c

	Abstract:
	IOCTL related subroutines

	Revision History:
	Who 		When		  What
	--------	----------	  ----------------------------------------------
	Rory Chen	01-03-2003	  created
	Rory Chen	02-14-2005	  modify to support RT61
*/

#include "rt_config.h"
#include <net/iw_handler.h>

#ifdef DBG
extern ULONG	RTDebugLevel;
#endif

#ifndef IW_ESSID_MAX_SIZE
/* Maximum size of the ESSID and NICKN strings */
#define IW_ESSID_MAX_SIZE	32
#endif

extern UCHAR	CipherWpa2Template[];
extern UCHAR	CipherWpa2TemplateLen;
extern UCHAR	CipherWpaPskTkip[];
extern UCHAR	CipherWpaPskTkipLen;

#define NR_WEP_KEYS 4
#define MAX_CUSTOM_LEN 64
//#define WEP_SMALL_KEY_LEN (40/8)  //move to rtmp_def.h
//#define WEP_LARGE_KEY_LEN (104/8)


/*
** Functions prototype
*/
static char * rtstrchr(const char * s, int c);
static void set_quality(PRTMP_ADAPTER pAdapter, struct iw_quality *iq, u_int rssi);

VOID RTMPIoctlGetSiteSurvey(IN PRTMP_ADAPTER pAdapter, 	IN struct iwreq *wrq);
VOID RTMPIoctlStatistics(IN PRTMP_ADAPTER pAd, IN struct iwreq *wrq);
VOID RTMPIoctlBBP(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
VOID RTMPIoctlMAC(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
INT RTMPIoctlSetAuth(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
INT RTMPIoctlSetEncryp(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
INT RTMPIoctlSetWpapsk(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
INT RTMPIoctlSetPsm(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
VOID RTMPIoctlGetRaAPCfg(IN PRTMP_ADAPTER pAdapter, IN struct iwreq *wrq);
NDIS_STATUS RTMPWPANoneAddKeyProc(IN PRTMP_ADAPTER pAd, IN PVOID pBuf);

INT Set_DriverVersion_Proc(IN PRTMP_ADAPTER pAd, IN PUCHAR arg);
INT Set_CountryRegion_Proc(IN PRTMP_ADAPTER pAd, IN PUCHAR arg);
INT Set_CountryRegionABand_Proc(IN PRTMP_ADAPTER pAd, IN PUCHAR arg);
INT Set_SSID_Proc(	IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_WirelessMode_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_TxRate_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_Channel_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_BGProtection_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_TxPreamble_Proc(IN PRTMP_ADAPTER pAdapter, 	IN PUCHAR arg);
INT Set_RTSThreshold_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_FragThreshold_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_TxBurst_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_AdhocModeRate_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
#ifdef AGGREGATION_SUPPORT
INT	Set_PktAggregate_Proc(IN PRTMP_ADAPTER pAd, IN PUCHAR arg);
#endif
INT Set_TurboRate_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_IEEE80211H_Proc(IN PRTMP_ADAPTER pAd, IN PUCHAR arg);
INT Set_NetworkType_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_AuthMode_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_EncrypType_Proc(IN PRTMP_ADAPTER pAdapter, 	IN PUCHAR arg);
INT Set_DefaultKeyID_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_Key1_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_Key2_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_Key3_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_Key4_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_WPAPSK_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_ResetStatCounter_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_PSMode_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
INT Set_OpMode_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
#ifdef DBG
INT Set_Debug_Proc(IN PRTMP_ADAPTER pAdapter, IN PUCHAR arg);
#endif

int rt_ioctl_giwname(struct net_device *dev, struct iw_request_info *info, char *name, char *extra);
int rt_ioctl_siwfreq(struct net_device *dev, struct iw_request_info *info, struct iw_freq *freq, char *extra);
int rt_ioctl_giwfreq(struct net_device *dev, struct iw_request_info *info, struct iw_freq *freq, char *extra);
int rt_ioctl_siwmode(struct net_device *dev, struct iw_request_info *info, __u32 *mode, char *extra);
int rt_ioctl_giwmode(struct net_device *dev, struct iw_request_info *info, __u32 *mode, char *extra);
int rt_ioctl_siwsens(struct net_device *dev, struct iw_request_info *info, char *name, char *extra);
int rt_ioctl_giwsens(struct net_device *dev, struct iw_request_info *info, char *name, char *extra);
int rt_ioctl_giwrange(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *extra);
int rt_ioctl_giwap(struct net_device *dev, struct iw_request_info *info, struct sockaddr *ap_addr, char *extra);
int rt_ioctl_iwaplist(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *extra);
#ifdef SIOCGIWSCAN
int rt_ioctl_siwscan(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *extra);
int rt_ioctl_giwscan(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *extra);
#endif // SIOCGIWSCAN //
int rt_ioctl_siwessid(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *essid);
int rt_ioctl_giwessid(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *essid);
int rt_ioctl_siwnickn(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *nickname);
int rt_ioctl_giwnickn(struct net_device *dev, struct iw_request_info *info, struct iw_point *data, char *nickname);
int rt_ioctl_siwrts(struct net_device *dev, struct iw_request_info *info, struct iw_param *rts, char *extra);
int rt_ioctl_giwrts(struct net_device *dev, struct iw_request_info *info, struct iw_param *rts, char *extra);
int rt_ioctl_siwfrag(struct net_device *dev, struct iw_request_info *info, struct iw_param *rts, char *extra);
int rt_ioctl_giwfrag(struct net_device *dev, struct iw_request_info *info, struct iw_param *rts, char *extra);
int rt_ioctl_siwencode(struct net_device *dev, struct iw_request_info *info, struct iw_point *erq, char *keybuf);
int rt_ioctl_giwencode(struct net_device *dev, struct iw_request_info *info, struct iw_point *erq, char *key);
int rt_ioctl_setparam(struct net_device *dev, struct iw_request_info *info, void *w, char *extra);


static struct {
	CHAR *name;
	INT (*set_proc)(PRTMP_ADAPTER pAdapter, PUCHAR arg);
} *PRTMP_PRIVATE_SET_PROC, RTMP_PRIVATE_SUPPORT_PROC[] = {
	{"DriverVersion",				Set_DriverVersion_Proc},
	{"CountryRegion",				Set_CountryRegion_Proc},
	{"CountryRegionABand",			Set_CountryRegionABand_Proc},
	{"SSID",						Set_SSID_Proc},
	{"WirelessMode",				Set_WirelessMode_Proc},
	{"TxRate",						Set_TxRate_Proc},
	{"Channel",						Set_Channel_Proc},
	{"BGProtection",				Set_BGProtection_Proc},
	{"TxPreamble",					Set_TxPreamble_Proc},
	{"RTSThreshold",				Set_RTSThreshold_Proc},
	{"FragThreshold",				Set_FragThreshold_Proc},
	{"TxBurst",						Set_TxBurst_Proc},
	{"AdhocOfdm",					Set_AdhocModeRate_Proc},
#ifdef AGGREGATION_SUPPORT
	{"PktAggregate",				Set_PktAggregate_Proc},
#endif
#if 0
	{"TurboRate",					Set_TurboRate_Proc},
	{"WmmCapable",					Set_WmmCapable_Proc},
#endif
	{"IEEE80211H",					Set_IEEE80211H_Proc},
	{"NetworkType", 				Set_NetworkType_Proc},
	{"AuthMode",					Set_AuthMode_Proc},
	{"EncrypType",					Set_EncrypType_Proc},
	{"DefaultKeyID",				Set_DefaultKeyID_Proc},
	{"Key1",						Set_Key1_Proc},
	{"Key2",						Set_Key2_Proc},
	{"Key3",						Set_Key3_Proc},
	{"Key4",						Set_Key4_Proc},
	{"WPAPSK",						Set_WPAPSK_Proc},
	{"ResetCounter",				Set_ResetStatCounter_Proc},
	{"PSMode",						Set_PSMode_Proc},
	{"OpMode",						Set_OpMode_Proc},
#ifdef DBG
	{"Debug",						Set_Debug_Proc},
#endif
	{NULL,}
};

struct iw_priv_args privtab[] = {
{ RTPRIV_IOCTL_SET,
  IW_PRIV_TYPE_CHAR | 1024, 0,
  "set"},

#ifdef DBG
{ RTPRIV_IOCTL_BBP,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "bbp"},
{ RTPRIV_IOCTL_MAC,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "mac"},
#endif

{ RTPRIV_IOCTL_STATISTICS,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "stat"},
{ RTPRIV_IOCTL_GSITESURVEY,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024 ,
  "get_site_survey"},
{ RTPRIV_IOCTL_GETRAAPCFG,  IW_PRIV_TYPE_CHAR | 1024, 0,
  "get_RaAP_Cfg"},
#if 1
{ RTPRIV_IOCTL_AUTH,
  IW_PRIV_TYPE_INT	|1, 0,
  "auth"},
{ RTPRIV_IOCTL_WEPSTATUS,
  IW_PRIV_TYPE_INT	|1, 0,
  "enc"},
{ RTPRIV_IOCTL_WPAPSK,
  IW_PRIV_TYPE_CHAR |64, 0,
  "wpapsk"},
{ RTPRIV_IOCTL_PSM,
 IW_PRIV_TYPE_INT  |1, 0,
 "psm"},
#endif
};

static const iw_handler rt_handler[] =
{
	(iw_handler) NULL,						/* SIOCSIWCOMMIT */
	(iw_handler) rt_ioctl_giwname,			/* SIOCGIWNAME	1 */
	(iw_handler) NULL,						/* SIOCSIWNWID */
	(iw_handler) NULL,						/* SIOCGIWNWID */
	(iw_handler) rt_ioctl_siwfreq,			/* SIOCSIWFREQ */
	(iw_handler) rt_ioctl_giwfreq,			/* SIOCGIWFREQ	5 */
	(iw_handler) rt_ioctl_siwmode,			/* SIOCSIWMODE */
	(iw_handler) rt_ioctl_giwmode,			/* SIOCGIWMODE */
	(iw_handler) NULL,						/* SIOCSIWSENS */
	(iw_handler) NULL,						/* SIOCGIWSENS */
	(iw_handler) NULL /* not used */,		/* SIOCSIWRANGE */
	(iw_handler) rt_ioctl_giwrange,			/* SIOCGIWRANGE 11 */
	(iw_handler) NULL /* not used */,		/* SIOCSIWPRIV */
	(iw_handler) NULL /* kernel code */,	/* SIOCGIWPRIV */
	(iw_handler) NULL /* not used */,		/* SIOCSIWSTATS */
	(iw_handler) NULL /* kernel code */,	/* SIOCGIWSTATS f */
	(iw_handler) NULL,						/* SIOCSIWSPY */
	(iw_handler) NULL,						/* SIOCGIWSPY */
	(iw_handler) NULL,						/* -- hole -- */
	(iw_handler) NULL,						/* -- hole -- */
	(iw_handler) NULL,						/* SIOCSIWAP */
	(iw_handler) rt_ioctl_giwap,			/* SIOCGIWAP	0x15*/
	(iw_handler) NULL,						/* -- hole --	0x16 */
	(iw_handler) rt_ioctl_iwaplist,			/* SIOCGIWAPLIST */
#ifdef SIOCGIWSCAN
	(iw_handler) rt_ioctl_siwscan,			/* SIOCSIWSCAN	0x18*/
	(iw_handler) rt_ioctl_giwscan,			/* SIOCGIWSCAN */
#else
	(iw_handler) NULL,						/* SIOCSIWSCAN */
	(iw_handler) NULL,						/* SIOCGIWSCAN */
#endif /* SIOCGIWSCAN */
	(iw_handler) rt_ioctl_siwessid,			/* SIOCSIWESSID */
	(iw_handler) rt_ioctl_giwessid,			/* SIOCGIWESSID */
	(iw_handler) rt_ioctl_siwnickn,			/* SIOCSIWNICKN */
	(iw_handler) rt_ioctl_giwnickn,			/* SIOCGIWNICKN 1d*/
	(iw_handler) NULL,						/* -- hole -- */
	(iw_handler) NULL,						/* -- hole -- */
	(iw_handler) NULL,						/* SIOCSIWRATE	20*/
	(iw_handler) NULL,						/* SIOCGIWRATE */
	(iw_handler) rt_ioctl_siwrts,			/* SIOCSIWRTS */
	(iw_handler) rt_ioctl_giwrts,			/* SIOCGIWRTS */
	(iw_handler) rt_ioctl_siwfrag,			/* SIOCSIWFRAG */
	(iw_handler) rt_ioctl_giwfrag,			/* SIOCGIWFRAG	25*/
	(iw_handler) NULL,						/* SIOCSIWTXPOW */
	(iw_handler) NULL,						/* SIOCGIWTXPOW */
	(iw_handler) NULL,						/* SIOCSIWRETRY */
	(iw_handler) NULL,						/* SIOCGIWRETRY  29*/
	(iw_handler) rt_ioctl_siwencode,		/* SIOCSIWENCODE 2a*/
	(iw_handler) rt_ioctl_giwencode,		/* SIOCGIWENCODE 2b*/
	(iw_handler) NULL,						/* SIOCSIWPOWER  2c*/
	(iw_handler) NULL,						/* SIOCGIWPOWER  2d*/
};

static const iw_handler rt_priv_handlers[] = {
	(iw_handler) NULL,					/* SIOCWFIRSTPRIV+0 */
	(iw_handler) rt_ioctl_setparam,		/* SIOCWFIRSTPRIV+2 */
};


const struct iw_handler_def rt73_iw_handler_def =
{
#define	N(a)	(sizeof (a) / sizeof (a[0]))
	.standard	= (iw_handler *) rt_handler,
	.num_standard	= sizeof(rt_handler) / sizeof(iw_handler),
	.private	= (iw_handler *) rt_priv_handlers,
	.num_private		= N(rt_priv_handlers),
	.private_args	= (struct iw_priv_args *) privtab,
	.num_private_args	= N(privtab),
#if WIRELESS_EXT > 15
//	.spy_offset	= offsetof(struct hostap_interface, spy_data),
#endif /* WIRELESS_EXT > 15 */
};

/*
This is required for LinEX2004/kernel2.6.7 to provide iwlist scanning function
*/
int rt_ioctl_giwname(struct net_device *dev,
	struct iw_request_info *info,
	char *name, char *extra)
{
	strncpy(name, "RT73 WLAN", IFNAMSIZ);
	return 0;
}

int rt_ioctl_siwfreq(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_freq *freq, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	int 	chan = -1;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (freq->e > 1)
		return -EINVAL;

	if((freq->e == 0) && (freq->m <= 1000))
		chan = freq->m;	// Setting by channel number
	else
		MAP_KHZ_TO_CHANNEL_ID( (freq->m /100) , chan); // Setting by frequency - search the table , like 2.412G, 2.422G,

// 	pAdapter->CommonCfg.Channel = chan;
/* ~~sample, bug fix, 2006/10/18 */
    if (ChannelSanity(pAdapter, chan) == TRUE)
    	pAdapter->CommonCfg.Channel = chan;
    else
        return -EINVAL;
    /* End of if */

	DBGPRINT(RT_DEBUG_ERROR, ("==>rt_ioctl_siwfreq::SIOCSIWFREQ[cmd=0x%x] (Channel=%d)\n", SIOCSIWFREQ, pAdapter->CommonCfg.Channel));


	return 0;
}

int rt_ioctl_giwfreq(struct net_device *dev,
		   struct iw_request_info *info,
		   struct iw_freq *freq, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	ULONG	m;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	DBGPRINT(RT_DEBUG_TRACE, ("==>rt_ioctl_giwfreq  %d\n", pAdapter->CommonCfg.Channel));

	MAP_CHANNEL_ID_TO_KHZ(pAdapter->CommonCfg.Channel, m);
	freq->m = m * 100;
	freq->e = 1;

	return 0;
}

int rt_ioctl_siwmode(struct net_device *dev,
	struct iw_request_info *info,
	__u32 *mode, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

	if (pAdapter->OpMode == OPMODE_AP)
        return -ENETDOWN;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	switch (*mode)
	{
		case IW_MODE_ADHOC:
			if (pAdapter->StaCfg.BssType != BSS_ADHOC)
			{
				// Config has changed
				if (INFRA_ON(pAdapter))
				{
					RTUSBEnqueueInternalCmd(pAdapter, RT_OID_LINK_DOWN, NULL, 0);
					// First cancel linkdown timer
					DBGPRINT(RT_DEBUG_TRACE, ("NDIS_STATUS_MEDIA_DISCONNECT Event BB!\n"));
				}

			}
			pAdapter->StaCfg.BssType = BSS_ADHOC;
			DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_siwmode::SIOCSIWMODE (AD-HOC)\n"));
			break;
		case IW_MODE_INFRA:
			if (pAdapter->StaCfg.BssType != BSS_INFRA)
			{
				// Config has changed
				if (ADHOC_ON(pAdapter))
					RTUSBEnqueueInternalCmd(pAdapter, RT_OID_LINK_DOWN, NULL, 0);
			}
			pAdapter->StaCfg.BssType = BSS_INFRA;
			DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_siwmode::SIOCSIWMODE (INFRA)\n"));
			break;
		default:
			DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_siwmode::SIOCSIWMODE (unknown)\n"));
			return -EINVAL;
	}

	// Reset Ralink supplicant to not use, it will be set to start when UI set PMK key
	pAdapter->StaCfg.WpaState = SS_NOTUSE;

	return 0;
}

int rt_ioctl_giwmode(struct net_device *dev,
	struct iw_request_info *info,
	__u32 *mode, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

	do
	{
		if (pAdapter->OpMode == OPMODE_AP)
		{
			*mode = IW_MODE_INFRA;
			break;
		}

		//check if the interface is down
		if (pAdapter->RTUSBCmdThr_pid < 0)
			return -ENETDOWN;

		if (ADHOC_ON(pAdapter))
			*mode = IW_MODE_ADHOC;
		else if (INFRA_ON(pAdapter))
			*mode = IW_MODE_INFRA;
		else
			*mode = IW_MODE_AUTO;

	} while(FALSE);

	DBGPRINT(RT_DEBUG_TRACE, ("==>rt_ioctl_giwmode\n"));
	return 0;
}

int rt_ioctl_siwsens(struct net_device *dev,
	struct iw_request_info *info,
	char *name, char *extra)
{
    PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	return 0;
}

int rt_ioctl_giwsens(struct net_device *dev,
	struct iw_request_info *info,
	char *name, char *extra)
{
    PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	return 0;
}

int rt_ioctl_giwrange(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	struct iw_range *range = (struct iw_range *) extra;
	u16 val;
	int i;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_giwrange\n"));
	data->length = sizeof(struct iw_range);
	memset(range, 0, sizeof(struct iw_range));

	range->txpower_capa = IW_TXPOW_DBM;

	if (INFRA_ON(pAdapter)||ADHOC_ON(pAdapter))
	{
		range->min_pmp = 1 * 1024;
		range->max_pmp = 65535 * 1024;
		range->min_pmt = 1 * 1024;
		range->max_pmt = 1000 * 1024;
		range->pmp_flags = IW_POWER_PERIOD;
		range->pmt_flags = IW_POWER_TIMEOUT;
		range->pm_capa = IW_POWER_PERIOD | IW_POWER_TIMEOUT |
			IW_POWER_UNICAST_R | IW_POWER_ALL_R;
	}

	range->we_version_compiled = WIRELESS_EXT;
	range->we_version_source = 14;

	range->retry_capa = IW_RETRY_LIMIT;
	range->retry_flags = IW_RETRY_LIMIT;
	range->min_retry = 0;
	range->max_retry = 255;

	range->num_channels =  pAdapter->ChannelListNum;

	val = 0;

	for (i = 1; i <= range->num_channels; i++) {
		u32 m;
		range->freq[val].i = pAdapter->ChannelList[i-1].Channel;
		MAP_CHANNEL_ID_TO_KHZ(pAdapter->ChannelList[i-1].Channel, m);
		range->freq[val].m = m * 100; /* HZ */

		range->freq[val].e = 1;
		val++;
		if (val == IW_MAX_FREQUENCIES)
			break;
	}

	range->num_frequency = val;

	range->max_qual.qual = 100; /* what is correct max? This was not
                                * documented exactly. At least
					            * 69 has been observed. */
	range->max_qual.level = 0; /* dB */
	range->max_qual.noise = 0; /* dB */

	/* What would be suitable values for "average/typical" qual? */
	range->avg_qual.qual = 20;
	range->avg_qual.level = -60;
	range->avg_qual.noise = -95;
	range->sensitivity = 3;

	range->max_encoding_tokens = NR_WEP_KEYS;
	range->num_encoding_sizes = 2;
	range->encoding_size[0] = 5;
	range->encoding_size[1] = 13;

#if 0
	over2 = 0;
	len = prism2_get_datarates(dev, rates);
	range->num_bitrates = 0;
	for (i = 0; i < len; i++) {
		if (range->num_bitrates < IW_MAX_BITRATES) {
			range->bitrate[range->num_bitrates] =
				rates[i] * 500000;
			range->num_bitrates++;
		}
		if (rates[i] == 0x0b || rates[i] == 0x16)
			over2 = 1;
	}
	/* estimated maximum TCP throughput values (bps) */
	range->throughput = over2 ? 5500000 : 1500000;
#endif
	range->min_rts = 0;
	range->max_rts = 2347;
	range->min_frag = 256;
	range->max_frag = 2346;

	return 0;
}

int rt_ioctl_giwap(struct net_device *dev,
	struct iw_request_info *info,
	struct sockaddr *ap_addr, char *extra)
{

	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (INFRA_ON(pAdapter) || ADHOC_ON(pAdapter))
	{
		ap_addr->sa_family = ARPHRD_ETHER;
		memcpy(ap_addr->sa_data, &pAdapter->CommonCfg.Bssid, ETH_ALEN);
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIWAP(=EMPTY)\n"));
		return -ENOTCONN;
	}

	return 0;
}

int rt_ioctl_iwaplist(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *extra)
{

	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	struct sockaddr addr[IW_MAX_AP];
	struct iw_quality qual[IW_MAX_AP];
	int i;

	if (pAdapter->OpMode == OPMODE_AP)
		return -ENETDOWN;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	for (i = 0; i <IW_MAX_AP ; i++)
	{
		if (i >=  pAdapter->ScanTab.BssNr)
			break;
		addr[i].sa_family = ARPHRD_ETHER;
			memcpy(addr[i].sa_data, &pAdapter->ScanTab.BssEntry[i].Bssid, MAC_ADDR_LEN);
		set_quality(pAdapter, &qual[i], pAdapter->ScanTab.BssEntry[i].Rssi);
	}
	data->length = i;
	memcpy(extra, &addr, i*sizeof(addr[0]));
	data->flags = 1;		/* signal quality present (sort of) */
	memcpy(extra + i*sizeof(addr[0]), &qual, i*sizeof(qual[i]));

	return 0;
}

#ifdef SIOCGIWSCAN
int rt_ioctl_siwscan(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *extra)
{
	LARGE_INTEGER Now;
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	int Status = NDIS_STATUS_SUCCESS;
	//BOOLEAN		StateMachineTouched = FALSE;

	if (pAdapter->OpMode == OPMODE_AP)
		return -ENETDOWN;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS))
		return 0;
	do{
		NdisGetCurrentSystemTime(&Now);

		if ((OPSTATUS_TEST_FLAG(pAdapter, fOP_STATUS_MEDIA_STATE_CONNECTED)) &&
			((pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
			(pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK) ||
			(pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPA1PSKWPA2PSK) ||
			(pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ||
			(pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2PSK)) &&
			(pAdapter->StaCfg.PortSecured == WPA_802_1X_PORT_NOT_SECURED)
			)
		{
			DBGPRINT(RT_DEBUG_TRACE, ("!!! Link UP, Port Not Secured! ignore this set::OID_802_11_BSSID_LIST_SCAN\n"));
			Status = NDIS_STATUS_SUCCESS;
			break;
		}

		if (pAdapter->Mlme.CntlMachine.CurrState != CNTL_IDLE  && (pAdapter->MLMEThr_pid > 0))
		{
			MlmeEnqueue(pAdapter,
                        MLME_CNTL_STATE_MACHINE,
                        RT_CMD_RESET_MLME,
                        0,
                        NULL);
		}

		// tell CNTL state machine to call NdisMSetInformationComplete() after completing
		// this request, because this request is initiated by NDIS.
		pAdapter->MlmeAux.CurrReqIsFromNdis = FALSE;
		// Reset Missed scan number
		pAdapter->StaCfg.ScanCnt = 0;
		pAdapter->StaCfg.LastScanTime = Now;

		MlmeEnqueue(pAdapter,
					MLME_CNTL_STATE_MACHINE,
					OID_802_11_BSSID_LIST_SCAN,
					0,
					NULL);
		RTUSBMlmeUp(pAdapter);

		Status = NDIS_STATUS_SUCCESS;
		//StateMachineTouched = TRUE;

	}while(0);
	return 0;
}

int rt_ioctl_giwscan(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *extra)
{

	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	int i=2, j;
	char *current_ev = extra, *previous_ev = extra;
	char *end_buf = extra + IW_SCAN_MAX_DATA;   // some of platforms restricted on IW_SCAN_MAX_DATA
	char *current_val;
    struct iw_event iwe;

#if 0   // support bit rate, extended rate, quality and last beacon timing
    //-------------------------------------------
	char custom[MAX_CUSTOM_LEN];
	char *p;
	char SupRateLen, ExtRateLen;
	char rate, max_rate;
    int  k;
	//-------------------------------------------
#endif

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS)){
		/*
		 * Still scanning, indicate the caller should try again.
		 */
		return -EAGAIN;
	}
	for (i = 0; i < pAdapter->ScanTab.BssNr; i++)
	{
		if (current_ev >= end_buf)
			break;

		//MAC address
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWAP;
		iwe.u.ap_addr.sa_family = ARPHRD_ETHER;
        memcpy(iwe.u.ap_addr.sa_data, &pAdapter->ScanTab.BssEntry[i].Bssid, ETH_ALEN);

        previous_ev = current_ev;
        current_ev = iwe_stream_add_event(current_ev,end_buf, &iwe, IW_EV_ADDR_LEN);
        if (current_ev == previous_ev)
            break;

		//ESSID
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWESSID;
		iwe.u.data.length = pAdapter->ScanTab.BssEntry[i].SsidLen;
		iwe.u.data.flags = 1;

        previous_ev = current_ev;
		current_ev = iwe_stream_add_point(current_ev,end_buf, &iwe, pAdapter->ScanTab.BssEntry[i].Ssid);
        if (current_ev == previous_ev)
            break;

		//Network Type
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWMODE;
		if (pAdapter->ScanTab.BssEntry[i].BssType == Ndis802_11IBSS)
		{
			iwe.u.mode = IW_MODE_ADHOC;
		}
		else if (pAdapter->ScanTab.BssEntry[i].BssType == Ndis802_11Infrastructure)
		{
			iwe.u.mode = IW_MODE_INFRA;
		}
		else
		{
			iwe.u.mode = IW_MODE_AUTO;
		}
		iwe.len = IW_EV_UINT_LEN;

        previous_ev = current_ev;
		current_ev = iwe_stream_add_event(current_ev, end_buf, &iwe,  IW_EV_UINT_LEN);
        if (current_ev == previous_ev)
            break;

		//Channel and Frequency
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWFREQ;
		if (INFRA_ON(pAdapter) || ADHOC_ON(pAdapter))
			iwe.u.freq.m = pAdapter->ScanTab.BssEntry[i].Channel;
		else
			iwe.u.freq.m = pAdapter->ScanTab.BssEntry[i].Channel;
		iwe.u.freq.e = 0;
		iwe.u.freq.i = 0;

		previous_ev = current_ev;
		current_ev = iwe_stream_add_event(current_ev,end_buf, &iwe, IW_EV_FREQ_LEN);
        if (current_ev == previous_ev)
            break;

		//Encyption key
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWENCODE;
		if (CAP_IS_PRIVACY_ON (pAdapter->ScanTab.BssEntry[i].CapabilityInfo ))
			iwe.u.data.flags =IW_ENCODE_ENABLED | IW_ENCODE_NOKEY;
		else
			iwe.u.data.flags = IW_ENCODE_DISABLED;

        previous_ev = current_ev;
        current_ev = iwe_stream_add_point(current_ev, end_buf, &iwe, (char *)pAdapter->SharedKey[BSS0][(iwe.u.data.flags & IW_ENCODE_INDEX)-1].Key);
        if (current_ev == previous_ev)
            break;

#if 1	// support bit rate
		//Bit Rate
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWRATE;
		current_val = current_ev + IW_EV_LCP_LEN;
		//for (j = 0; j < pAdapter->ScanTab.BssEntry[i].RatesLen;j++)
		for (j = 0; j < 1;j++)
		{
			iwe.u.bitrate.value = RateIdToMbps[pAdapter->ScanTab.BssEntry[i].SupRate[i]/2] * 1000000;
			iwe.u.bitrate.disabled = 0;
			current_val = iwe_stream_add_value(current_ev,
				current_val, end_buf, &iwe,
				IW_EV_PARAM_LEN);
		}


        if((current_val-current_ev)>IW_EV_LCP_LEN)
            current_ev = current_val;
        else
            break;


#else	// support bit rate, extended rate, quality and last beacon timing
        // max. of displays used IW_SCAN_MAX_DATA are about 22~24 cells
		//Bit Rate
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWRATE;
		current_val = current_ev + IW_EV_LCP_LEN;

		SupRateLen = pAdapter->ScanTab.BssEntry[i].SupRateLen;
		ExtRateLen = pAdapter->ScanTab.BssEntry[i].ExtRateLen;

		max_rate = 0;
		p = custom;
		p += snprintf(p, MAX_CUSTOM_LEN - (p - custom), " Rates (Mb/s): ");
		for (k = 0, j = 0; k < SupRateLen; )
		{
			if (j < ExtRateLen &&
			((pAdapter->ScanTab.BssEntry[i].ExtRate[j] & 0x7F) <
				(pAdapter->ScanTab.BssEntry[i].SupRate[k] & 0x7F)))
			{
				rate = pAdapter->ScanTab.BssEntry[i].ExtRate[j++] & 0x7F;
			}
			else
			{
				rate = pAdapter->ScanTab.BssEntry[i].SupRate[k++] & 0x7F;
			}

			if (rate > max_rate)
				max_rate = rate;
			p += snprintf(p, MAX_CUSTOM_LEN - (p - custom),
					  "%d%s ", rate >> 1, (rate & 1) ? ".5" : "");
		}

		for (; j < ExtRateLen; j++)
		{
			rate = pAdapter->ScanTab.BssEntry[i].ExtRate[j] & 0x7F;
			p += snprintf(p, MAX_CUSTOM_LEN - (p - custom),
					  "%d%s ", rate >> 1, (rate & 1) ? ".5" : "");
			if (rate > max_rate)
				max_rate = rate;
		}
		iwe.u.bitrate.value = max_rate * 500000;
		iwe.u.bitrate.disabled = 0;
		current_val = iwe_stream_add_value(current_ev,
			current_val, end_buf, &iwe,
			IW_EV_PARAM_LEN);
		if((current_val-current_ev)>IW_EV_LCP_LEN)
			current_ev = current_val;
		else
		    break;

		//Extended Rate
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = IWEVCUSTOM;
		iwe.u.data.length = p - custom;
		if (iwe.u.data.length)
		{
		    previous_ev = current_ev;
			current_ev = iwe_stream_add_point(current_ev, end_buf, &iwe, custom);
            if (current_ev == previous_ev)
                break;
        }
		//Quality Statistics
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = IWEVQUAL;
		set_quality(pAdapter, &iwe.u.qual, pAdapter->ScanTab.BssEntry[i].Rssi);

		previous_ev = current_ev;
		current_ev = iwe_stream_add_event(current_ev, end_buf, &iwe, IW_EV_QUAL_LEN);
        if (current_ev == previous_ev)
            break;

		//Age to display seconds since last beacon
		//================================
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = IWEVCUSTOM;
		p = custom;
		p += snprintf(p, MAX_CUSTOM_LEN - (p - custom),
				  " Last beacon: %lums ago", (jiffies - pAdapter->ScanTab.BssEntry[i].LastBeaconRxTime) / (HZ / 100));
		iwe.u.data.length = p - custom;
		if (iwe.u.data.length)
		{
		    previous_ev = current_ev;
			current_ev = iwe_stream_add_point(current_ev, end_buf, &iwe, custom);
            if (current_ev == previous_ev)
                break;
        }
#endif

		//================================
		memset(&iwe, 0, sizeof(iwe));

	}
	data->length = current_ev - extra;
	DBGPRINT(RT_DEBUG_ERROR, ("===>rt_ioctl_giwscan. %d(%d) BSS returned\n",i , pAdapter->ScanTab.BssNr));
	return 0;
}
#endif // SIOCGIWSCAN //

int rt_ioctl_siwessid(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *essid)
{

	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	NDIS_802_11_SSID					Ssid, *pSsid=NULL;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

    memset(&Ssid, 0x00, sizeof(NDIS_802_11_SSID));

	if (data->flags)
	{
		if (data->length > IW_ESSID_MAX_SIZE)
		{
			return -E2BIG;
		}

		memcpy(Ssid.Ssid, essid, (data->length - 1));
		Ssid.SsidLength = data->length - 1;	//minus null character.
	}
	else
	{
		Ssid.SsidLength = 0;  // ANY ssid
        memcpy(Ssid.Ssid, "", 0);

		if (pAdapter->OpMode == OPMODE_STA)
		{
			// reset to infra/open/none as the user set ANY ssid
			// $ iwconfig [interface] essid ""
			pAdapter->StaCfg.BssType = BSS_INFRA;
			pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;
			pAdapter->CommonCfg.WepStatus  = Ndis802_11EncryptionDisabled;
		}
    }

	pSsid = &Ssid;

	if (pAdapter->OpMode == OPMODE_AP)
	{
		RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_SSID, TRUE, pSsid, sizeof(NDIS_802_11_SSID));
	}
	else
	{
		if ((pAdapter->Mlme.CntlMachine.CurrState != CNTL_IDLE) && (pAdapter->MLMEThr_pid > 0))
		{
			MlmeEnqueue(pAdapter,
	                    MLME_CNTL_STATE_MACHINE,
	                    RT_CMD_RESET_MLME,
	                    0,
	                    NULL);
	    }

		// tell CNTL state machine to call NdisMSetInformationComplete() after completing
		// this request, because this request is initiated by NDIS.

		// To prevent some kernel thread is very low priority ...so essid copy immediately for later wpapsk counting.
		if ((pAdapter->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA) && (pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPANone))
			NdisMoveMemory(pAdapter->MlmeAux.Ssid, Ssid.Ssid, Ssid.SsidLength);

		pAdapter->MlmeAux.CurrReqIsFromNdis = FALSE;
		DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_siwessid:: (Ssid.SsidLength = %d, %s)\n",Ssid.SsidLength, Ssid.Ssid));

		if (pAdapter->MLMEThr_pid > 0)
		{
			MlmeEnqueue(pAdapter,
						MLME_CNTL_STATE_MACHINE,
						OID_802_11_SSID,
						sizeof(NDIS_802_11_SSID),
						(VOID *)pSsid);
		}
		RTUSBMlmeUp(pAdapter);
	}
	return 0;
}

int rt_ioctl_giwessid(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *essid)
{

	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	data->flags = 1;		/* active */
	if (OPSTATUS_TEST_FLAG(pAdapter, fOP_STATUS_MEDIA_STATE_CONNECTED))
	{
		DBGPRINT(RT_DEBUG_TRACE, ("MediaState is connected\n"));
		data->length = pAdapter->CommonCfg.SsidLen;
		memcpy(essid, pAdapter->CommonCfg.Ssid, pAdapter->CommonCfg.SsidLen);
		pAdapter->CommonCfg.Ssid[pAdapter->CommonCfg.SsidLen] = '\0';
		DBGPRINT(RT_DEBUG_TRACE, ("pAdapter->StaCfg.Ssid=%s , Ssidlen = %d\n",pAdapter->CommonCfg.Ssid, pAdapter->CommonCfg.SsidLen));
	}
	else
	{//the ANY ssid was specified
		data->length  = 0;
		DBGPRINT(RT_DEBUG_TRACE, ("MediaState is not connected, ess\n"));
	}
	DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_giwessid:: (Len=%d, ssid=%s...)\n", pAdapter->CommonCfg.SsidLen, pAdapter->CommonCfg.Ssid));

	return 0;

}

int rt_ioctl_siwnickn(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *nickname)
{
#if 1 /* fonchi todo. */
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (data->length > IW_ESSID_MAX_SIZE)
		return -EINVAL;

	memset(pAdapter->nickn, 0, IW_ESSID_MAX_SIZE);
	memcpy(pAdapter->nickn, nickname, data->length);

#endif
	return 0;
}

int rt_ioctl_giwnickn(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *data, char *nickname)
{
#if 1 /* fonchi todo. */
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (data->length > strlen(pAdapter->nickn) + 1)
		data->length = strlen(pAdapter->nickn) + 1;

	if (data->length > 0) {
		memcpy(nickname, pAdapter->nickn, data->length-1);
		nickname[data->length-1] = '\0';
	}
#endif
	return 0;
}

int rt_ioctl_siwrts(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_param *rts, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	u16 val;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (rts->disabled)
		val = MAX_RTS_THRESHOLD;
	else if (rts->value < 0 || rts->value > MAX_RTS_THRESHOLD)
		return -EINVAL;
	else if (rts->value == 0)
		val = MAX_RTS_THRESHOLD;
	else
		val = rts->value;

	if (val != pAdapter->CommonCfg.RtsThreshold)
		pAdapter->CommonCfg.RtsThreshold = val;

	return 0;
}

int rt_ioctl_giwrts(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_param *rts, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	rts->value = pAdapter->CommonCfg.RtsThreshold;
	rts->disabled = (rts->value == MAX_RTS_THRESHOLD);
	rts->fixed = 1;

	return 0;
}

int rt_ioctl_siwfrag(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_param *rts, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	u16 val;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (rts->disabled)
		val = MAX_FRAG_THRESHOLD;
	else if (rts->value >= MIN_FRAG_THRESHOLD || rts->value <= MAX_FRAG_THRESHOLD)
		val = __cpu_to_le16(rts->value & ~0x1); /* even numbers only */
	else if (rts->value == 0)
		val = MAX_FRAG_THRESHOLD;
	else
		return -EINVAL;

	pAdapter->CommonCfg.FragmentThreshold = val;
	return 0;
}

int rt_ioctl_giwfrag(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_param *rts, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	rts->value = pAdapter->CommonCfg.FragmentThreshold;
	rts->disabled = (rts->value == 2346);
	rts->fixed = 1;

	return 0;
}

int rt_ioctl_siwencode(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *erq, char *keybuf)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	union {
		char buf[sizeof(NDIS_802_11_WEP)+MAX_LEN_OF_KEY- 1];
		NDIS_802_11_WEP keyinfo;
	} WepKey;
	int 	index, i, len;
	CHAR	kid = 0;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	NdisZeroMemory(&WepKey, sizeof(WepKey));

	if (erq->flags & IW_ENCODE_DISABLED)
	{
		pAdapter->CommonCfg.PairCipher = Ndis802_11WEPDisabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11WEPDisabled;
		pAdapter->CommonCfg.WepStatus = Ndis802_11WEPDisabled;
	}
	else
	{
		pAdapter->CommonCfg.PairCipher = Ndis802_11WEPEnabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11WEPEnabled;
		pAdapter->CommonCfg.WepStatus = Ndis802_11WEPEnabled;
	}

	if (erq->flags & IW_ENCODE_RESTRICTED)
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeShared;
	else
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;

	if(pAdapter->CommonCfg.WepStatus == Ndis802_11WEPDisabled)
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;

	if ((erq->flags & IW_ENCODE_DISABLED) == 0)
	{
		/* Enable crypto. */
		if (erq->length > IFNAMSIZ)
			return -EINVAL;

		/* Old solution to take  default key  */
		index = (erq->flags & IW_ENCODE_INDEX) ;
		if((index < 0) || (index > NR_WEP_KEYS))
			return -EINVAL;
		DBGPRINT(RT_DEBUG_TRACE, (" erq->flags = %x\n",erq->flags));

		if (index != 0)
		{
			pAdapter->CommonCfg.DefaultKeyId = index -1;
		}

		if ((erq->length == 1) && (index == 0))
		{
			/* New solution to take  default key  when old way not work, not change KeyMaterial*/
			NdisMoveMemory(&kid, keybuf, 1 );
			if((index < 0) || (index >= NR_WEP_KEYS))
				return -EINVAL;

			DBGPRINT(RT_DEBUG_TRACE, ("kid = %d , erq->length = %d\n",kid, erq->length));
			if (kid > 0)
				pAdapter->CommonCfg.DefaultKeyId = kid-1;
			else
				pAdapter->CommonCfg.DefaultKeyId = 0;
		}
		else
		{
			DBGPRINT(RT_DEBUG_TRACE, ("DefaultKeyId = %d , erq->length = %d, flags 0x%x\n",pAdapter->CommonCfg.DefaultKeyId, erq->length,erq->flags));
			len = erq->length;
			if(len > WEP_LARGE_KEY_LEN)
				len = WEP_LARGE_KEY_LEN;

			// If this instruction default key
			NdisZeroMemory(pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].Key,  MAX_LEN_OF_KEY);
			NdisMoveMemory(pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].Key, keybuf, len);
			NdisMoveMemory(WepKey.keyinfo.KeyMaterial, keybuf, len);
			WepKey.keyinfo.KeyIndex = 0x80000000 + pAdapter->CommonCfg.DefaultKeyId;
			WepKey.keyinfo.KeyLength = len;
			pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].KeyLen =(UCHAR) (len <= WEP_SMALL_KEY_LEN ? WEP_SMALL_KEY_LEN : WEP_LARGE_KEY_LEN);
			DBGPRINT(RT_DEBUG_TRACE, ("SharedKey	"));
			for (i=0; i < 5;i++)
				DBGPRINT_RAW(RT_DEBUG_TRACE, ("	%x ", pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].Key[i]));
			DBGPRINT(RT_DEBUG_TRACE, ("\n"));
			// need to enqueue cmd to thread
			RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_ADD_WEP, TRUE, &WepKey, sizeof(WepKey.keyinfo) + len - 1);

		}

	}
	DBGPRINT(RT_DEBUG_TRACE, ("==>rt_ioctl_siwencode::AuthMode=%x\n",pAdapter->CommonCfg.AuthMode));
	DBGPRINT(RT_DEBUG_TRACE, ("==>rt_ioctl_siwencode::DefaultKeyId=%x, KeyLen = %d\n",pAdapter->CommonCfg.DefaultKeyId , pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].KeyLen));
	DBGPRINT(RT_DEBUG_TRACE, ("==>rt_ioctl_siwencode::WepStatus=%x\n",pAdapter->CommonCfg.WepStatus));
	return 0;
}

int rt_ioctl_giwencode(struct net_device *dev,
	struct iw_request_info *info,
	struct iw_point *erq, char *key)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	int kid;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	kid = erq->flags & IW_ENCODE_INDEX;
	DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_giwencode %d\n", erq->flags & IW_ENCODE_INDEX));

	if (pAdapter->CommonCfg.WepStatus == Ndis802_11WEPDisabled)
	{
		erq->length = 0;
		erq->flags = IW_ENCODE_DISABLED;
	}
	else if ((kid > 0) && (kid <=4))
	{
		// copy wep key
		erq->flags = kid ;			/* NB: base 1 */
		if (erq->length > pAdapter->SharedKey[BSS0][kid-1].KeyLen)
			erq->length = pAdapter->SharedKey[BSS0][kid-1].KeyLen;
		memcpy(key, pAdapter->SharedKey[BSS0][kid-1].Key, erq->length);
		//if ((kid == pAdapter->CommonCfg.DefaultKeyId))
		//erq->flags |= IW_ENCODE_ENABLED;	/* XXX */
		if (pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeShared)
			erq->flags |= IW_ENCODE_RESTRICTED;		/* XXX */
		else
			erq->flags |= IW_ENCODE_OPEN;		/* XXX */

	}
	else if (kid == 0)
	{
		if (pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeShared)
			erq->flags |= IW_ENCODE_RESTRICTED;		/* XXX */
		else
			erq->flags |= IW_ENCODE_OPEN;		/* XXX */
		erq->length = pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].KeyLen;
		memcpy(key, pAdapter->SharedKey[BSS0][pAdapter->CommonCfg.DefaultKeyId].Key, erq->length);
		// copy default key ID
		if (pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeShared)
			erq->flags |= IW_ENCODE_RESTRICTED;		/* XXX */
		else
			erq->flags |= IW_ENCODE_OPEN;		/* XXX */
		erq->flags = pAdapter->CommonCfg.DefaultKeyId + 1;			/* NB: base 1 */
		erq->flags |= IW_ENCODE_ENABLED;	/* XXX */
	}

	return 0;

}

int rt_ioctl_setparam(struct net_device *dev,
	struct iw_request_info *info,
	void *w, char *extra)
{
	PRTMP_ADAPTER pAdapter = (PRTMP_ADAPTER) dev->priv;
	char *this_char = extra;
	char *value;
	int  Status=0;

    //check if the interface is down
    if (pAdapter->RTUSBCmdThr_pid < 0)
        return -ENETDOWN;

	if (!*this_char)
		return Status;

	if ((value = rtstrchr(this_char, '=')) != NULL)
		*value++ = 0;

	if (!value)
		return Status;

	// reject setting nothing besides ANY ssid(ssidLen=0)
	if (!*value && (strcmp(this_char, "SSID") != 0))
		return Status;

	for (PRTMP_PRIVATE_SET_PROC = RTMP_PRIVATE_SUPPORT_PROC; PRTMP_PRIVATE_SET_PROC->name; PRTMP_PRIVATE_SET_PROC++)
	{
		if (strcmp(this_char, PRTMP_PRIVATE_SET_PROC->name) == 0)
		{
			if(!PRTMP_PRIVATE_SET_PROC->set_proc(pAdapter, value))
			{	//FALSE:Set private failed then return Invalid argument
				Status = -EINVAL;
			}
			break;	//Exit for loop.
		}
	}

	if(PRTMP_PRIVATE_SET_PROC->name == NULL)
	{  //Not found argument
		Status = -EINVAL;
		DBGPRINT(RT_DEBUG_TRACE, ("===>rt_ioctl_setparam:: (iwpriv) Not Support Set Command [%s=%s]\n", this_char, value));
	}

	return Status;
}

INT rt73_ioctl(
	IN	struct net_device	*net_dev,
	IN	OUT	struct ifreq	*rq,
	IN	INT					cmd)
{
	RTMP_ADAPTER						*pAd = net_dev->priv;
	struct iwreq						*wrq = (struct iwreq *) rq;
	struct iw_point 					*erq = NULL;
	struct iw_freq						*frq = NULL;
	NDIS_802_11_SSID					Ssid, *pSsid=NULL;
	NDIS_802_11_NETWORK_INFRASTRUCTURE	BssType = Ndis802_11Infrastructure;
	NDIS_802_11_RTS_THRESHOLD			RtsThresh;
	NDIS_802_11_FRAGMENTATION_THRESHOLD FragThresh;
	NDIS_802_11_MAC_ADDRESS 			Bssid;
	BOOLEAN 							StateMachineTouched = FALSE;
	INT 								Status = NDIS_STATUS_SUCCESS;
	USHORT								subcmd;
	int 								chan=-1, index=0, len=0, i=0;
	ULONG								BytesRead, BytesWritten, BytesNeeded;


	if ( (RTMP_TEST_FLAG(pAd , fRTMP_ADAPTER_NIC_NOT_EXIST)) ||
		 (RTMP_TEST_FLAG(pAd , fRTMP_ADAPTER_RESET_IN_PROGRESS)))
	{
		DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::remove in progress!\n"));
		return -ENETDOWN;
	}
	if (pAd->RTUSBCmdThr_pid < 0)
		return -ENETDOWN;

	switch(cmd)
	{
		case SIOCGIFHWADDR:     //get  MAC addresses
			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIFHWADDR\n"));
			memcpy(wrq->u.name, pAd->CurrentAddress, ETH_ALEN);
            DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIFHWADDR(=%02x:%02x:%02x:%02x:%02x:%02x)\n",
		        pAd->CurrentAddress[0],pAd->CurrentAddress[1],pAd->CurrentAddress[2],
		        pAd->CurrentAddress[3],pAd->CurrentAddress[4],pAd->CurrentAddress[5]));
			break;
		case SIOCGIWNAME:
			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIWNAME\n"));
			strcpy(wrq->u.name, "RT73 WLAN");
			break;
		case SIOCSIWESSID:	//Set ESSID
			erq = &wrq->u.essid;
			memset(&Ssid, 0x00, sizeof(NDIS_802_11_SSID));
			if (erq->flags)
			{
				if (erq->length > IW_ESSID_MAX_SIZE)
				{
					Status = -E2BIG;
					break;
				}

				Status = copy_from_user(Ssid.Ssid, erq->pointer, (erq->length - 1));
				Ssid.SsidLength = erq->length - 1;	//minus null character.
			}
			else
			{
				Ssid.SsidLength = 0;  // ANY ssid
				memcpy(pSsid->Ssid, "", 0);
			}
			pSsid = &Ssid;
			if (pAd->Mlme.CntlMachine.CurrState != CNTL_IDLE)
			{
				MlmeEnqueue(pAd,
				            MLME_CNTL_STATE_MACHINE,
				            RT_CMD_RESET_MLME,
				            0,
				            NULL);
			}

			// tell CNTL state machine to call NdisMSetInformationComplete() after completing
			// this request, because this request is initiated by NDIS.
			pAd->MlmeAux.CurrReqIsFromNdis = FALSE;

			MlmeEnqueue(pAd,
						MLME_CNTL_STATE_MACHINE,
						OID_802_11_SSID,
						sizeof(NDIS_802_11_SSID),
						(VOID *)pSsid);

			Status = NDIS_STATUS_SUCCESS;
			StateMachineTouched = TRUE;

			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWESSID[cmd=0x%x] (Len=%d,Ssid=%s)\n", SIOCSIWESSID, pSsid->SsidLength, pSsid->Ssid));
			break;
		case SIOCGIWESSID:	//Get ESSID
			erq = &wrq->u.essid;

			 if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED))
			{
				erq->flags=1;
				erq->length = pAd->CommonCfg.SsidLen;
				Status = copy_to_user(erq->pointer, pAd->CommonCfg.Ssid, erq->length);
			}
			else
			{//the ANY ssid was specified
				erq->flags=0;
				erq->length=0;
			}
			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIWESSID (Len=%d, ssid=%lu...)\n", erq->length, (unsigned long)erq->pointer));
			break;
		case SIOCSIWNWID:	// set network id (the cell)
		case SIOCGIWNWID:	// get network id
			Status = -EOPNOTSUPP;
			break;
		case SIOCSIWFREQ:	//set channel/frequency (Hz)
			frq = &wrq->u.freq;
			if((frq->e == 0) && (frq->m <= 1000))
				chan = frq->m;	// Setting by channel number
			else
				MAP_KHZ_TO_CHANNEL_ID( (frq->m /100) , chan); // Setting by frequency - search the table , like 2.412G, 2.422G,
			pAd->CommonCfg.Channel = chan;
			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWFREQ[cmd=0x%x] (Channel=%d)\n", SIOCSIWFREQ, pAd->CommonCfg.Channel));
			break;
		case SIOCGIWFREQ:	// get channel/frequency (Hz)
			wrq->u.freq.m = pAd->CommonCfg.Channel;
			wrq->u.freq.e = 0;
			wrq->u.freq.i = 0;
			break;
		case SIOCSIWNICKN: //set node name/nickname
#if 0 /* fonchi todo. */
			erq = &wrq->u.data;
			if (erq->flags)
			{
				if (erq->length <= IW_ESSID_MAX_SIZE)
					Status = copy_from_user(pAd->nickn, erq->pointer, erq->length);
				else
					Status = -E2BIG;
			}
#endif
			break;
		case SIOCGIWNICKN: //get node name/nickname
#if 0 /* fonchi todo. */
			erq = &wrq->u.data;
			erq->length = strlen(pAd->nickn);
			Status = copy_to_user(erq->pointer, pAd->nickn, erq->length);
#endif
			break;

		case SIOCGIWRATE:	//get default bit rate (bps)
			wrq->u.bitrate.value = RateIdTo500Kbps[pAd->CommonCfg.TxRate] * 500000;
			wrq->u.bitrate.disabled = 0;
			break;
		case SIOCSIWRATE:  //set default bit rate (bps)
			RTMPSetDesiredRates(pAd, wrq->u.bitrate.value);
			break;
		case SIOCGIWRTS:  // get RTS/CTS threshold (bytes)
			wrq->u.rts.value = (INT) pAd->CommonCfg.RtsThreshold;
			wrq->u.rts.disabled = (wrq->u.rts.value == MAX_RTS_THRESHOLD);
			wrq->u.rts.fixed = 1;
			break;
		case SIOCSIWRTS:  //set RTS/CTS threshold (bytes)
			RtsThresh = wrq->u.rts.value;
			if (wrq->u.rts.disabled)
				RtsThresh = MAX_RTS_THRESHOLD;

			if((RtsThresh > 0) && (RtsThresh <= MAX_RTS_THRESHOLD))
				pAd->CommonCfg.RtsThreshold = (USHORT)RtsThresh;
			else if (RtsThresh == 0)
				pAd->CommonCfg.RtsThreshold = MAX_RTS_THRESHOLD;

			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWRTS (=%d)\n", pAd->CommonCfg.RtsThreshold));
			break;
		case SIOCGIWFRAG:  //get fragmentation thr (bytes)
			wrq->u.frag.value = (INT) pAd->CommonCfg.FragmentThreshold;
			wrq->u.frag.disabled = (wrq->u.frag.value >= MAX_FRAG_THRESHOLD);
			wrq->u.frag.fixed = 1;
			break;
		case SIOCSIWFRAG:  //set fragmentation thr (bytes)
			FragThresh = wrq->u.frag.value;
			if (wrq->u.rts.disabled)
				FragThresh = MAX_FRAG_THRESHOLD;

			if ( (FragThresh >= MIN_FRAG_THRESHOLD) && (FragThresh <= MAX_FRAG_THRESHOLD))
				pAd->CommonCfg.FragmentThreshold = (USHORT)FragThresh;
			else if (FragThresh == 0)
				pAd->CommonCfg.FragmentThreshold = MAX_FRAG_THRESHOLD;

			if (pAd->CommonCfg.FragmentThreshold == MAX_FRAG_THRESHOLD)
				pAd->CommonCfg.bUseZeroToDisableFragment = TRUE;
			else
				pAd->CommonCfg.bUseZeroToDisableFragment = FALSE;

			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWFRAG (=%d)\n", pAd->CommonCfg.FragmentThreshold));
			break;
		case SIOCGIWENCODE:  //get encoding token & mode
			index = (wrq->u.encoding.flags & IW_ENCODE_INDEX) - 1;
			if ((index < 0) || (index >= NR_WEP_KEYS))
				index = pAd->CommonCfg.DefaultKeyId; // Default key for tx (shared key)

			if (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeOpen)
				wrq->u.encoding.flags = IW_ENCODE_OPEN;
			else if (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeShared)
				wrq->u.encoding.flags = IW_ENCODE_RESTRICTED;

			if (pAd->CommonCfg.WepStatus == Ndis802_11WEPDisabled)
				wrq->u.encoding.flags |= IW_ENCODE_DISABLED;
			else
			{
				if(wrq->u.encoding.pointer)
				{
					wrq->u.encoding.length = pAd->SharedKey[BSS0][index].KeyLen;
					Status = copy_to_user(wrq->u.encoding.pointer,
								pAd->SharedKey[BSS0][index].Key,
								pAd->SharedKey[BSS0][index].KeyLen);
					wrq->u.encoding.flags |= (index + 1);
				}
			}
			break;
		case SIOCSIWENCODE:  //set encoding token & mode
			index = (wrq->u.encoding.flags & IW_ENCODE_INDEX) - 1;
			/* take the old default key if index is invalid */
			if((index < 0) || (index >= NR_WEP_KEYS))
				index = pAd->CommonCfg.DefaultKeyId;	   // Default key for tx (shared key)

			if(wrq->u.encoding.pointer)
			{
				len = wrq->u.encoding.length;
				if(len > WEP_LARGE_KEY_LEN)
					len = WEP_LARGE_KEY_LEN;

				memset(pAd->SharedKey[BSS0][index].Key, 0x00, MAX_LEN_OF_KEY);
				Status = copy_from_user(pAd->SharedKey[BSS0][index].Key,
								wrq->u.encoding.pointer, len);
				pAd->SharedKey[BSS0][index].KeyLen = len <= WEP_SMALL_KEY_LEN ? WEP_SMALL_KEY_LEN : WEP_LARGE_KEY_LEN;
			}
			pAd->CommonCfg.DefaultKeyId = (UCHAR) index;
			if (wrq->u.encoding.flags & IW_ENCODE_DISABLED)
				pAd->CommonCfg.WepStatus = Ndis802_11WEPDisabled;
			else
				pAd->CommonCfg.WepStatus = Ndis802_11WEPEnabled;

			if (wrq->u.encoding.flags & IW_ENCODE_RESTRICTED)
				pAd->CommonCfg.AuthMode = Ndis802_11AuthModeShared;
			else
				pAd->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;

			if(pAd->CommonCfg.WepStatus == Ndis802_11WEPDisabled)
				pAd->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;

			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWENCODE Key[%x] => \n", index));
			for (i = 0; i < len; i++)
			{
				DBGPRINT(RT_DEBUG_TRACE, ("%02x:", pAd->SharedKey[BSS0][index].Key[i]));
				if (i%16 == 15)
					DBGPRINT(RT_DEBUG_TRACE, ("\n"));
			}
			DBGPRINT(RT_DEBUG_TRACE, ("\n"));
			break;
		case SIOCGIWAP: 	//get access point MAC addresses
			if (INFRA_ON(pAd) || ADHOC_ON(pAd))
			{
				wrq->u.ap_addr.sa_family = ARPHRD_ETHER;
				memcpy(wrq->u.ap_addr.sa_data, &pAd->CommonCfg.Bssid, ETH_ALEN);
				DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIWAP(=%02x:%02x:%02x:%02x:%02x:%02x)\n",
					pAd->CommonCfg.Bssid[0],pAd->CommonCfg.Bssid[1],pAd->CommonCfg.Bssid[2],
					pAd->CommonCfg.Bssid[3],pAd->CommonCfg.Bssid[4],pAd->CommonCfg.Bssid[5]));
			}
			else
			{
				DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIWAP(=EMPTY)\n"));
				Status = -ENOTCONN;
			}
			break;
		case SIOCSIWAP:  //set access point MAC addresses
			Status = copy_from_user(&Bssid, &wrq->u.ap_addr.sa_data, sizeof(NDIS_802_11_MAC_ADDRESS));
			if (pAd->Mlme.CntlMachine.CurrState != CNTL_IDLE)
			{
				MlmeEnqueue(pAd,
				            MLME_CNTL_STATE_MACHINE,
				            RT_CMD_RESET_MLME,
				            0,
				            NULL);
			}

			// tell CNTL state machine to call NdisMSetInformationComplete() after completing
			// this request, because this request is initiated by NDIS.
			pAd->MlmeAux.CurrReqIsFromNdis = FALSE;

			MlmeEnqueue(pAd,
						MLME_CNTL_STATE_MACHINE,
						OID_802_11_BSSID,
						sizeof(NDIS_802_11_MAC_ADDRESS),
						(VOID *)&Bssid);
			Status = NDIS_STATUS_SUCCESS;
			StateMachineTouched = TRUE;
			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWAP %02x:%02x:%02x:%02x:%02x:%02x\n",
				Bssid[0], Bssid[1], Bssid[2], Bssid[3], Bssid[4], Bssid[5]));
			break;
		case SIOCGIWMODE:	//get operation mode
			if (ADHOC_ON(pAd))
			{
				BssType = Ndis802_11IBSS;
				wrq->u.mode = IW_MODE_ADHOC;
			}
			else if (INFRA_ON(pAd))
			{
				BssType = Ndis802_11Infrastructure;
				wrq->u.mode = IW_MODE_INFRA;
			}
			else
			{
				BssType = Ndis802_11AutoUnknown;
				wrq->u.mode = IW_MODE_AUTO;
			}
			DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCGIWMODE(=%d)\n", BssType));
			break;
		case SIOCSIWMODE:	//set operation mode
			if(wrq->u.mode == IW_MODE_ADHOC)
			{
				if (pAd->StaCfg.BssType != BSS_ADHOC)
				{
					// Config has changed
					pAd->bConfigChanged = TRUE;
				}
				pAd->StaCfg.BssType = BSS_ADHOC;
				DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWMODE (AD-HOC)\n"));
			}
			else if (wrq->u.mode == IW_MODE_INFRA)
			{
				if (pAd->StaCfg.BssType != BSS_INFRA)
				{
					// Config has changed
					pAd->bConfigChanged = TRUE;
				}
				pAd->StaCfg.BssType = BSS_INFRA;
				DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWMODE (INFRA)\n"));
			}
			else
			{
				Status	= -EINVAL;
				DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::SIOCSIWMODE (unknown)\n"));
			}
			// Reset Ralink supplicant to not use, it will be set to start when UI set PMK key
			pAd->StaCfg.WpaState = SS_NOTUSE;
			break;
		case SIOCGIWSENS:	//get sensitivity (dBm)
		case SIOCSIWSENS:	//set sensitivity (dBm)
		case SIOCGIWPOWER:	//get Power Management settings
		case SIOCSIWPOWER:	//set Power Management settings
		case SIOCGIWTXPOW:	//get transmit power (dBm)
		case SIOCSIWTXPOW:	//set transmit power (dBm)
		case SIOCGIWRANGE:	//Get range of parameters
		case SIOCGIWRETRY:	//get retry limits and lifetime
		case SIOCSIWRETRY:	//set retry limits and lifetime
			Status = -EOPNOTSUPP;
			break;
		case RT_PRIV_IOCTL:
			subcmd = wrq->u.data.flags;
			if( subcmd & OID_GET_SET_TOGGLE)
				Status = RTMPSetInformation(pAd, subcmd, wrq->u.data.pointer, wrq->u.data.length, &BytesRead, &BytesNeeded);
			else
				Status = RTMPQueryInformation(pAd, subcmd, wrq->u.data.pointer, wrq->u.data.length, &BytesWritten, &BytesNeeded);
			break;
		case SIOCGIWPRIV:
			if (wrq->u.data.pointer) {
				if ( access_ok(VERIFY_WRITE, wrq->u.data.pointer, sizeof(privtab)) != TRUE)
					break;
				wrq->u.data.length = sizeof(privtab) / sizeof(privtab[0]);
				if (copy_to_user(wrq->u.data.pointer, privtab, sizeof(privtab)))
					Status = -EFAULT;
			}
			break;
		case RTPRIV_IOCTL_SET:
			{
				CHAR *this_char;
				CHAR *value;

				if( access_ok(VERIFY_READ, wrq->u.data.pointer, wrq->u.data.length)!=TRUE )
					break;

				this_char = kmalloc(wrq->u.data.length, MEM_ALLOC_FLAG);
				if(this_char == NULL)
				{
					Status = -ENOMEM;
					break;
				}

				Status = copy_from_user(this_char, wrq->u.data.pointer, wrq->u.data.length);

				if (!*this_char)
					break;

				if ((value = rtstrchr(this_char, '=')) != NULL)
					*value++ = 0;

				if (!value)
					break;

				// reject setting nothing besides ANY ssid(ssidLen=0)
				if (!*value && (strcmp(this_char, "SSID") != 0))
					break;

				for (PRTMP_PRIVATE_SET_PROC = RTMP_PRIVATE_SUPPORT_PROC; PRTMP_PRIVATE_SET_PROC->name; PRTMP_PRIVATE_SET_PROC++)
				{
					if (!strcmp(this_char, PRTMP_PRIVATE_SET_PROC->name))
					{
						if(!PRTMP_PRIVATE_SET_PROC->set_proc(pAd, value))
						{	//FALSE:Set private failed then return Invalid argument
							Status = -EINVAL;
						}
						break;	//Exit for loop.
					}
				}

				if(PRTMP_PRIVATE_SET_PROC->name == NULL)
				{  //Not found argument
					Status = -EINVAL;
					DBGPRINT(RT_DEBUG_TRACE, ("IOCTL::(iwpriv) Command not Support [%s=%s]\n", this_char, value));
					break;
				}
				kfree(this_char);
			}
			break;
		case RTPRIV_IOCTL_GSITESURVEY:
			RTMPIoctlGetSiteSurvey(pAd, wrq);
			break;

		case RTPRIV_IOCTL_STATISTICS:
			RTMPIoctlStatistics(pAd, wrq);
			break;
#ifdef DBG
		case RTPRIV_IOCTL_BBP:
			RTMPIoctlBBP(pAd, wrq);
			break;

		case RTPRIV_IOCTL_MAC:
			RTMPIoctlMAC(pAd, wrq);
			break;
#endif

#if 1
		case RTPRIV_IOCTL_AUTH:
			Status = RTMPIoctlSetAuth(pAd, wrq);
			break;
		case RTPRIV_IOCTL_WEPSTATUS:
			Status = RTMPIoctlSetEncryp(pAd, wrq);
			break;
		case RTPRIV_IOCTL_WPAPSK:
			Status = RTMPIoctlSetWpapsk(pAd, wrq);
			break;
		case RTPRIV_IOCTL_PSM:
			Status = RTMPIoctlSetPsm(pAd, wrq);
			break;
#endif
        	case RTPRIV_IOCTL_GETRAAPCFG:
			RTMPIoctlGetRaAPCfg(pAd, wrq);
			break;
		default:
			DBGPRINT(RT_DEBUG_ERROR, ("IOCTL::unknown IOCTL's cmd = 0x%08x\n", cmd));
			if (cmd == 0x89F1)
				Status = NDIS_STATUS_SUCCESS; // ignore default config by some of platforms, e.g. SuSE
			else
				Status = -EOPNOTSUPP;

			break;
	}

	if(StateMachineTouched) // Upper layer sent a MLME-related operations
		RTUSBMlmeUp(pAd);


	return Status;
}

INT Set_DriverVersion_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, ("Driver version-%s\n", DRIVER_VERSION));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Country Region.
		This command will not work, if the field of CountryRegion in eeprom is programmed.
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_CountryRegion_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	ULONG region;

	region = simple_strtol(arg, 0, 10);

	// Country can be set only when EEPROM not programmed
	if (pAd->CommonCfg.CountryRegion & 0x80)
	{
		DBGPRINT(RT_DEBUG_ERROR, ("Set_CountryRegion_Proc::parameter of CountryRegion in eeprom is programmed \n"));
		return FALSE;
	}

	if(region <= REGION_MAXIMUM_BG_BAND)
	{
		pAd->CommonCfg.CountryRegion = (UCHAR) region;
	}
	else
	{
		DBGPRINT(RT_DEBUG_ERROR, ("Set_CountryRegion_Proc::parameters out of range\n"));
		return FALSE;
	}

	// if set country region, driver needs to be reset
	BuildChannelList(pAd);

	DBGPRINT(RT_DEBUG_TRACE, ("Set_CountryRegion_Proc::(CountryRegion=%d)\n", pAd->CommonCfg.CountryRegion));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Country Region for A band.
		This command will not work, if the field of CountryRegion in eeprom is programmed.
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_CountryRegionABand_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	ULONG region;

	region = simple_strtol(arg, 0, 10);

	// Country can be set only when EEPROM not programmed
	if (pAd->CommonCfg.CountryRegionForABand & 0x80)
	{
		DBGPRINT(RT_DEBUG_ERROR, ("Set_CountryRegionABand_Proc::parameter of CountryRegion in eeprom is programmed \n"));
		return FALSE;
	}

	if(region <= REGION_MAXIMUM_A_BAND)
	{
		pAd->CommonCfg.CountryRegionForABand = (UCHAR) region;
	}
	else
	{
		DBGPRINT(RT_DEBUG_ERROR, ("Set_CountryRegionABand_Proc::parameters out of range\n"));
		return FALSE;
	}

	// if set country region, driver needs to be reset
	BuildChannelList(pAd);

	DBGPRINT(RT_DEBUG_TRACE, ("Set_CountryRegionABand_Proc::(CountryRegion=%d)\n", pAd->CommonCfg.CountryRegionForABand));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set SSID
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_SSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	NDIS_802_11_SSID					Ssid, *pSsid=NULL;
	BOOLEAN 							StateMachineTouched = FALSE;
	int 								success = TRUE;

	if( strlen(arg) <= MAX_LEN_OF_SSID)
	{
		NdisZeroMemory(Ssid.Ssid, MAX_LEN_OF_SSID);
		if (strlen(arg) != 0)
		{
			NdisMoveMemory(Ssid.Ssid, arg, strlen(arg));
			Ssid.SsidLength = strlen(arg);
		}
		else
		{
			Ssid.SsidLength = 0; //ANY ssid
			memcpy(Ssid.Ssid, "", 0);

			if (pAdapter->OpMode == OPMODE_STA)
			{
				// reset to infra/open/none as the user sets ANY ssid
				// $ iwpriv [interface] set SSID=""
				pAdapter->StaCfg.BssType = BSS_INFRA;
				pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;
				pAdapter->CommonCfg.WepStatus  = Ndis802_11EncryptionDisabled;
			}
		}

		pSsid = &Ssid;

		if (pAdapter->OpMode == OPMODE_AP)
		{
			RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_SSID, TRUE, pSsid, sizeof(NDIS_802_11_SSID));
		}
		else
		{
			if (pAdapter->OpMode == OPMODE_STA)
			{
				if (pAdapter->Mlme.CntlMachine.CurrState != CNTL_IDLE)
				{
					MlmeEnqueue(pAdapter,
								MLME_CNTL_STATE_MACHINE,
								RT_CMD_RESET_MLME,
								0,
								NULL);
				}
			}
		    // tell CNTL state machine to call NdisMSetInformationComplete() after completing
			// this request, because this request is initiated by NDIS.
			pAdapter->MlmeAux.CurrReqIsFromNdis = FALSE;

			MlmeEnqueue(pAdapter,
						MLME_CNTL_STATE_MACHINE,
						OID_802_11_SSID,
						sizeof(NDIS_802_11_SSID),
						(VOID *)pSsid);

			StateMachineTouched = TRUE;
		}
		DBGPRINT(RT_DEBUG_TRACE, ("Set_SSID_Proc::(Len=%d,Ssid=%s)\n", Ssid.SsidLength, Ssid.Ssid));
	}
	else
		success = FALSE;

	if (StateMachineTouched) // Upper layer sent a MLME-related operations
		RTUSBMlmeUp(pAdapter);

	return success;
}

/*
	==========================================================================
	Description:
		Set Wireless Mode
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_WirelessMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	ULONG								WirelessMode;
	int 								success = TRUE;

	WirelessMode = simple_strtol(arg, 0, 10);

	if ((WirelessMode == PHY_11BG_MIXED) || (WirelessMode == PHY_11B) ||
		(WirelessMode == PHY_11A) || (WirelessMode == PHY_11ABG_MIXED) ||
		(WirelessMode == PHY_11G))
	{
		// protect no A-band support
		if ((pAdapter->RfIcType != RFIC_5226) && (pAdapter->RfIcType != RFIC_5225))
		{
			if ((WirelessMode == PHY_11A) || (WirelessMode == PHY_11ABG_MIXED))
			{
				DBGPRINT_ERR(("!!!!! Not support A band in RfIcType= %d\n", pAdapter->RfIcType));
				return FALSE;
			}
		}

		RTMPSetPhyMode(pAdapter, WirelessMode);
		DBGPRINT(RT_DEBUG_TRACE, ("Set_WirelessMode_Proc::(=%d)\n", WirelessMode));

		return success;
	}
	else
	{
		DBGPRINT(RT_DEBUG_ERROR, ("Set_WirelessMode_Proc::parameters out of range\n"));
		return FALSE;
	}
}

/*
	==========================================================================
	Description:
		Set TxRate
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_TxRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	ULONG								TxRate;
	int 								success = TRUE;

	TxRate = simple_strtol(arg, 0, 10);

	if ((pAdapter->CommonCfg.PhyMode == PHY_11B && TxRate <= 4) ||\
		((pAdapter->CommonCfg.PhyMode == PHY_11BG_MIXED || pAdapter->CommonCfg.PhyMode == PHY_11ABG_MIXED) && TxRate <= 12) ||\
		((pAdapter->CommonCfg.PhyMode == PHY_11A || pAdapter->CommonCfg.PhyMode == PHY_11G) && (TxRate == 0 ||(TxRate > 4 && TxRate <= 12))))
	{
		if (TxRate == 0)
			RTMPSetDesiredRates(pAdapter, -1);
		else
			RTMPSetDesiredRates(pAdapter, (LONG) (RateIdToMbps[TxRate-1] * 1000000));

		DBGPRINT(RT_DEBUG_TRACE, ("Set_TxRate_Proc::(TxRate=%d)\n", TxRate));

		return success;
	}
	else
	{
		DBGPRINT(RT_DEBUG_ERROR, ("Set_TxRate_Proc::parameters out of range\n"));
		return FALSE;	//Invalid argument
	}
}

/*
	==========================================================================
	Description:
		Set Channel
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_Channel_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	int 								success = TRUE;
	UCHAR								Channel;

	Channel = (UCHAR) simple_strtol(arg, 0, 10);

	if (ChannelSanity(pAdapter, Channel) == TRUE)
	{
		pAdapter->CommonCfg.Channel = Channel;
#if 0 /* fonchi todo. */
        if (pAdapter->StaCfg.BssType == BSS_ADHOC)
			pAdapter->PortCfg.AdhocChannel = pAdapter->CommonCfg.Channel; // sync. to the value of CommonCfg.Channel
#endif
		DBGPRINT(RT_DEBUG_TRACE, ("Set_Channel_Proc::(Channel=%d)\n", Channel));
	}
	else
		success = FALSE;

	return success;
}

#ifdef DBG
/*
	==========================================================================
	Description:
		For Debug information
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT	Set_Debug_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, ("==> Set_Debug_Proc *******************\n"));

	if(simple_strtol(arg, 0, 10) <= RT_DEBUG_LOUD)
		RTDebugLevel = simple_strtol(arg, 0, 10);

	DBGPRINT(RT_DEBUG_TRACE, ("<== Set_Debug_Proc(RTDebugLevel = %d)\n", RTDebugLevel));

	return TRUE;
}
#endif

/*
	==========================================================================
	Description:
		Set 11B/11G Protection
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_BGProtection_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)

{
	switch (simple_strtol(arg, 0, 10))
	{
		case 0: //AUTO
			pAdapter->CommonCfg.UseBGProtection = 0;
			break;
		case 1: //Always On
			pAdapter->CommonCfg.UseBGProtection = 1;
			break;
		case 2: //Always OFF
			pAdapter->CommonCfg.UseBGProtection = 2;
			break;
		default:  //Invalid argument
			return FALSE;
	}
	DBGPRINT(RT_DEBUG_TRACE, ("Set_BGProtection_Proc::(BGProtection=%d)\n", pAdapter->CommonCfg.UseBGProtection));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set TxPreamble
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_TxPreamble_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	RT_802_11_PREAMBLE					Preamble;

	Preamble = simple_strtol(arg, 0, 10);
	switch (Preamble)
	{
		case Rt802_11PreambleShort:
			pAdapter->CommonCfg.TxPreamble = Preamble;
			MlmeSetTxPreamble(pAdapter, Rt802_11PreambleShort);
			break;
		case Rt802_11PreambleLong:
		case Rt802_11PreambleAuto:
			// if user wants AUTO, initialize to LONG here, then change according to AP's
			// capability upon association.
			pAdapter->CommonCfg.TxPreamble = Preamble;
			MlmeSetTxPreamble(pAdapter, Rt802_11PreambleLong);
			break;
		default: //Invalid argument
			return FALSE;
	}

    /* ~~sample, bug fix, 2006/10/18, start */
	pAdapter->ApCfg.CapabilityInfo = CAP_GENERATE(1, 0, (pAdapter->CommonCfg.WepStatus != Ndis802_11EncryptionDisabled), (pAdapter->CommonCfg.TxPreamble == Rt802_11PreambleShort), pAdapter->CommonCfg.bUseShortSlotTime);
    /* ~~sample, bug fix, 2006/10/18, end */

	DBGPRINT(RT_DEBUG_TRACE, ("Set_TxPreamble_Proc::(TxPreamble=%d)\n", Preamble));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set RTS Threshold
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_RTSThreshold_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	NDIS_802_11_RTS_THRESHOLD			RtsThresh;

	RtsThresh = simple_strtol(arg, 0, 10);

	if((RtsThresh > 0) && (RtsThresh <= MAX_RTS_THRESHOLD))
		pAdapter->CommonCfg.RtsThreshold = (USHORT)RtsThresh;
	else if (RtsThresh == 0)
		pAdapter->CommonCfg.RtsThreshold = MAX_RTS_THRESHOLD;
	else
		return FALSE;

	DBGPRINT(RT_DEBUG_TRACE, ("Set_RTSThreshold_Proc::(RTSThreshold=%d)\n", pAdapter->CommonCfg.RtsThreshold));
	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Fragment Threshold
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_FragThreshold_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	NDIS_802_11_FRAGMENTATION_THRESHOLD 	FragThresh;

	FragThresh = simple_strtol(arg, 0, 10);

	if ( (FragThresh >= MIN_FRAG_THRESHOLD) && (FragThresh <= MAX_FRAG_THRESHOLD))
		pAdapter->CommonCfg.FragmentThreshold = (USHORT)FragThresh;
	else if (FragThresh == 0)
		pAdapter->CommonCfg.FragmentThreshold = MAX_FRAG_THRESHOLD;
	else
		return FALSE; //Invalid argument

	if (pAdapter->CommonCfg.FragmentThreshold == MAX_FRAG_THRESHOLD)
		pAdapter->CommonCfg.bUseZeroToDisableFragment = TRUE;
	else
		pAdapter->CommonCfg.bUseZeroToDisableFragment = FALSE;

	DBGPRINT(RT_DEBUG_TRACE, ("Set_FragThreshold_Proc::(FragThreshold=%d)\n", FragThresh));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set TxBurst
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_TxBurst_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	ULONG								TxBurst;

	TxBurst = simple_strtol(arg, 0, 10);

	if (TxBurst == 1)
		pAdapter->CommonCfg.bEnableTxBurst = TRUE;
	else if (TxBurst == 0)
		pAdapter->CommonCfg.bEnableTxBurst = FALSE;
	else
		return FALSE;  //Invalid argument

	DBGPRINT(RT_DEBUG_TRACE, ("Set_TxBurst_Proc::(TxBurst=%d)\n", pAdapter->CommonCfg.bEnableTxBurst));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set AdhocMode support Rate can or can not exceed 11Mbps against WiFi spec.
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_AdhocModeRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	ULONG		AdhocMode;

	AdhocMode = (ULONG)simple_strtol(arg, 0, 10);

	if (AdhocMode > 4)
		return FALSE;  //Invalid argument

	if (pAdapter->StaCfg.AdhocMode != AdhocMode)
	{
		pAdapter->StaCfg.AdhocMode = AdhocMode;
		MlmeUpdateTxRates(pAdapter, FALSE);
		MakeIbssBeacon(pAdapter);			// re-build BEACON frame
		AsicEnableIbssSync(pAdapter);		// copy to on-chip memory
	}

	DBGPRINT(RT_DEBUG_TRACE, ("Set_AdhocModeRate_Proc::(AdhocMode=%d)\n", pAdapter->StaCfg.AdhocMode));

	return TRUE;
}
#ifdef AGGREGATION_SUPPORT
/*
	==========================================================================
	Description:
		Set TxBurst
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT	Set_PktAggregate_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	ULONG aggre;

	aggre = simple_strtol(arg, 0, 10);

	if (aggre == 1)
		pAd->CommonCfg.bAggregationCapable = TRUE;
	else if (aggre == 0)
		pAd->CommonCfg.bAggregationCapable = FALSE;
	else
		return FALSE;  //Invalid argument

	DBGPRINT(RT_DEBUG_TRACE, ("Set_PktAggregate_Proc::(AGGRE=%d)\n", pAd->CommonCfg.bAggregationCapable));

	return TRUE;
}
#endif

/*
	==========================================================================
	Description:
		Set TurboRate Enable or Disable
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_TurboRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
#if 0 /* fonchi todo. */
	ULONG								TurboRate;

	TurboRate = simple_strtol(arg, 0, 10);

	if (TurboRate == 1)
		pAdapter->PortCfg.EnableTurboRate = TRUE;
	else if (TurboRate == 0)
		pAdapter->PortCfg.EnableTurboRate = FALSE;
	else
		return FALSE;  //Invalid argument

	DBGPRINT(RT_DEBUG_TRACE, ("Set_TurboRate_Proc::(TurboRate=%d)\n", pAdapter->PortCfg.EnableTurboRate));
#endif
	return TRUE;
}
#if 0
/*
	==========================================================================
	Description:
		Set WmmCapable Enable or Disable
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT	Set_WmmCapable_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	BOOLEAN	bWmmCapable;

	bWmmCapable = simple_strtol(arg, 0, 10);

	if (bWmmCapable == 1)
		pAd->CommonCfg.bWmmCapable = TRUE;
	else if (bWmmCapable == 0)
		pAd->CommonCfg.bWmmCapable = FALSE;
	else
		return FALSE;  //Invalid argument

	DBGPRINT(RT_DEBUG_TRACE, ("Set_WmmCapable_Proc::(bWmmCapable=%d)\n", pAd->CommonCfg.bWmmCapable));

	return TRUE;
}
#endif
/*
	==========================================================================
	Description:
		Set IEEE80211H.
		This parameter is 1 when needs radar detection, otherwise 0
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT	Set_IEEE80211H_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	ULONG ieee80211h;

	ieee80211h = simple_strtol(arg, 0, 10);

	if (ieee80211h == 1)
		pAd->CommonCfg.bIEEE80211H = TRUE;
	else if (ieee80211h == 0)
		pAd->CommonCfg.bIEEE80211H = FALSE;
	else
		return FALSE;  //Invalid argument

	DBGPRINT(RT_DEBUG_TRACE, ("Set_IEEE80211H_Proc::(IEEE80211H=%d)\n", pAd->CommonCfg.bIEEE80211H));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Network Type(Infrastructure/Adhoc mode)
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_NetworkType_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	if (pAdapter->OpMode == OPMODE_AP)
		return FALSE;

	if (strcmp(arg, "Adhoc") == 0)
	{
		if (pAdapter->StaCfg.BssType != BSS_ADHOC)
		{
			// Config has changed
			if (INFRA_ON(pAdapter))
				RTUSBEnqueueInternalCmd(pAdapter, RT_OID_LINK_DOWN, NULL, 0);
		}
		pAdapter->StaCfg.BssType = BSS_ADHOC;
	}
	else
	{
		if (pAdapter->StaCfg.BssType != BSS_INFRA)
		{
			// Config has changed
			if (ADHOC_ON(pAdapter))
				RTUSBEnqueueInternalCmd(pAdapter, RT_OID_LINK_DOWN, NULL, 0);
		}
		pAdapter->StaCfg.BssType = BSS_INFRA;
	}

	// Reset Ralink supplicant to not use, it will be set to start when UI set PMK key
	pAdapter->StaCfg.WpaState = SS_NOTUSE;

	DBGPRINT(RT_DEBUG_TRACE, ("Set_NetworkType_Proc::(NetworkType=%d)\n", pAdapter->StaCfg.BssType));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Authentication mode
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_AuthMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	if ((strcmp(arg, "WEPAUTO") == 0) || (strcmp(arg, "wepauto") == 0))
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeAutoSwitch;
	else if ((strcmp(arg, "OPEN") == 0) || (strcmp(arg, "open") == 0))
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;
	else if ((strcmp(arg, "SHARED") == 0) || (strcmp(arg, "shared") == 0))
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeShared;
	else if ((strcmp(arg, "WPAPSK") == 0) || (strcmp(arg, "wpapsk") == 0))
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPAPSK;
	else if ((strcmp(arg, "WPANONE") == 0) || (strcmp(arg, "wpanone") == 0))
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPANone;
	else if ((strcmp(arg, "WPA2PSK") == 0) || (strcmp(arg, "wpa2psk") == 0))
		pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPA2PSK;
    else if ((strcmp(arg, "WPA") == 0) || (strcmp(arg, "wpa") == 0))
        pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPA;
	else
		return FALSE;

	pAdapter->StaCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;

	DBGPRINT(RT_DEBUG_TRACE, ("Set_AuthMode_Proc::(AuthMode=%d)\n", pAdapter->CommonCfg.AuthMode));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Encryption Type
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_EncrypType_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	if ((strcmp(arg, "NONE") == 0) || (strcmp(arg, "none") == 0))
	{
		pAdapter->CommonCfg.WepStatus   = Ndis802_11WEPDisabled;
		pAdapter->CommonCfg.PairCipher  = Ndis802_11WEPDisabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11WEPDisabled;
	}
	else if ((strcmp(arg, "WEP") == 0) || (strcmp(arg, "wep") == 0))
	{
		pAdapter->CommonCfg.WepStatus   = Ndis802_11WEPEnabled;
		pAdapter->CommonCfg.PairCipher  = Ndis802_11WEPEnabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11WEPEnabled;
	}
	else if ((strcmp(arg, "TKIP") == 0) || (strcmp(arg, "tkip") == 0))
	{
		pAdapter->CommonCfg.WepStatus   = Ndis802_11Encryption2Enabled;
		pAdapter->CommonCfg.PairCipher  = Ndis802_11Encryption2Enabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11Encryption2Enabled;
	}
	else if ((strcmp(arg, "AES") == 0) || (strcmp(arg, "aes") == 0))
	{
		pAdapter->CommonCfg.WepStatus   = Ndis802_11Encryption3Enabled;
		pAdapter->CommonCfg.PairCipher  = Ndis802_11Encryption3Enabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11Encryption3Enabled;
	}
	/* ~~sample, mix mode add, 2006/10/13 */
	else if ((pAdapter->OpMode == OPMODE_AP)
		&& ((strcmp(arg, "TKIPAES") == 0) || (strcmp(arg, "tkipaes") == 0)))
	{
		pAdapter->CommonCfg.WepStatus   = Ndis802_11Encryption4Enabled;
		pAdapter->CommonCfg.PairCipher  = Ndis802_11Encryption4Enabled;
		pAdapter->CommonCfg.GroupCipher = Ndis802_11Encryption4Enabled;
	}
	else
		return FALSE;

	RTMPMakeRSNIE(pAdapter, pAdapter->CommonCfg.AuthMode, pAdapter->CommonCfg.WepStatus);
//	RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_WEP_STATUS, TRUE, &(pAdapter->CommonCfg.WepStatus),
//							sizeof(pAdapter->CommonCfg.WepStatus));

	DBGPRINT(RT_DEBUG_TRACE, ("Set_EncrypType_Proc::(EncrypType=%d)\n", pAdapter->CommonCfg.WepStatus));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Default Key ID
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_DefaultKeyID_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	ULONG								KeyIdx;

	KeyIdx = simple_strtol(arg, 0, 10);
	if((KeyIdx >= 1 ) && (KeyIdx <= 4))
		pAdapter->CommonCfg.DefaultKeyId = (UCHAR) (KeyIdx - 1 );
	else
		return FALSE;  //Invalid argument

	DBGPRINT(RT_DEBUG_TRACE, ("Set_DefaultKeyID_Proc::(DefaultKeyID=%d)\n", pAdapter->CommonCfg.DefaultKeyId));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set WEP KEY1
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_Key1_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	int 								KeyLen;
	int 								i;
	UCHAR								CipherAlg=CIPHER_WEP64;


	if (pAdapter->CommonCfg.WepStatus != Ndis802_11WEPEnabled ||\
		pAdapter->CommonCfg.DefaultKeyId != 0)
		return TRUE;	// do nothing

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->SharedKey[BSS0][0].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][0].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][0].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][0].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Hex"));
			break;
		case 13: //wep 104 Ascii type
			pAdapter->SharedKey[BSS0][0].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][0].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][0].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][0].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Hex"));
			break;
		default: //Invalid argument
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key1_Proc::Invalid argument (=%s)\n", arg));
			return FALSE;
	}

	pAdapter->SharedKey[BSS0][0].CipherAlg = CipherAlg;

	// Set keys (into ASIC)
	if (pAdapter->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
		;	// not support
	else	// Old WEP stuff
	{
		AsicAddSharedKeyEntry(pAdapter,
							  0,
							  0,
							  pAdapter->SharedKey[BSS0][0].CipherAlg,
							  pAdapter->SharedKey[BSS0][0].Key,
							  pAdapter->SharedKey[BSS0][0].KeyLen,
							  NULL,
							  NULL);
	}

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set WEP KEY2
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_Key2_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	int 								KeyLen;
	int 								i;
	UCHAR								CipherAlg=CIPHER_WEP64;

	if (pAdapter->CommonCfg.WepStatus != Ndis802_11WEPEnabled ||\
		pAdapter->CommonCfg.DefaultKeyId != 1)
		return TRUE;	// do nothing

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->SharedKey[BSS0][1].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][1].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][1].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][1].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Hex"));
			break;
		case 13: //wep 104 Ascii type
			pAdapter->SharedKey[BSS0][1].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][1].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][1].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][1].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Hex"));
			break;
		default: //Invalid argument
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key2_Proc::Invalid argument (=%s)\n", arg));
			return FALSE;
	}
	pAdapter->SharedKey[BSS0][1].CipherAlg = CipherAlg;

	// Set keys (into ASIC)
	if (pAdapter->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
		;	// not support
	else	// Old WEP stuff
	{
		AsicAddSharedKeyEntry(pAdapter,
							  0,
							  1,
							  pAdapter->SharedKey[BSS0][1].CipherAlg,
							  pAdapter->SharedKey[BSS0][1].Key,
							  pAdapter->SharedKey[BSS0][1].KeyLen,
							  NULL,
							  NULL);
	}

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set WEP KEY3
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_Key3_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	int 								KeyLen;
	int 								i;
	UCHAR								CipherAlg=CIPHER_WEP64;

	if (pAdapter->CommonCfg.WepStatus != Ndis802_11WEPEnabled ||\
		pAdapter->CommonCfg.DefaultKeyId != 2)
		return TRUE;	// do nothing

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->SharedKey[BSS0][2].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][2].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][2].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][2].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Hex"));
			break;
		case 13: //wep 104 Ascii type
			pAdapter->SharedKey[BSS0][2].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][2].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][2].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][2].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Hex"));
			break;
		default: //Invalid argument
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key3_Proc::Invalid argument (=%s)\n", arg));
			return FALSE;
	}
	pAdapter->SharedKey[BSS0][2].CipherAlg = CipherAlg;

	// Set keys (into ASIC)
	if (pAdapter->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
		;	// not support
	else	// Old WEP stuff
	{
		AsicAddSharedKeyEntry(pAdapter,
							  0,
							  2,
							  pAdapter->SharedKey[BSS0][2].CipherAlg,
							  pAdapter->SharedKey[BSS0][2].Key,
							  pAdapter->SharedKey[BSS0][2].KeyLen,
							  NULL,
							  NULL);
   }

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set WEP KEY4
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_Key4_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	int 								KeyLen;
	int 								i;
	UCHAR								CipherAlg=CIPHER_WEP64;

	if (pAdapter->CommonCfg.WepStatus != Ndis802_11WEPEnabled ||\
		pAdapter->CommonCfg.DefaultKeyId != 3)
		return TRUE;	// do nothing

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->SharedKey[BSS0][3].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][3].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][3].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][3].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP64;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Hex"));
			break;
		case 13: //wep 104 Ascii type
			pAdapter->SharedKey[BSS0][3].KeyLen = KeyLen;
			memcpy(pAdapter->SharedKey[BSS0][3].Key, arg, KeyLen);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Ascii"));
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->SharedKey[BSS0][3].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->SharedKey[BSS0][3].Key, KeyLen / 2);
			CipherAlg = CIPHER_WEP128;
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Hex"));
			break;
		default: //Invalid argument
			DBGPRINT(RT_DEBUG_TRACE, ("Set_Key4_Proc::Invalid argument (=%s)\n", arg));
			return FALSE;
	}
	pAdapter->SharedKey[BSS0][3].CipherAlg = CipherAlg;

	// Set keys (into ASIC)
	if (pAdapter->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
		;	// not support
	else	// Old WEP stuff
	{
		AsicAddSharedKeyEntry(pAdapter,
							  0,
							  3,
							  pAdapter->SharedKey[BSS0][3].CipherAlg,
							  pAdapter->SharedKey[BSS0][3].Key,
							  pAdapter->SharedKey[BSS0][3].KeyLen,
							  NULL,
							  NULL);
	}

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set WPA PSK key
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_WPAPSK_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	UCHAR					keyMaterial[40];
	INT 					Status;

	if ((pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPAPSK) &&\
		(pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPA2PSK) &&\
		(pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPANone) )
		return TRUE;	// do nothing

	DBGPRINT(RT_DEBUG_TRACE, ("Set_WPAPSK_Proc::(WPAPSK=%s)\n", arg));

	NdisZeroMemory(keyMaterial, 40);

	if ((strlen(arg) < 8) || (strlen(arg) > 64))
	{
		DBGPRINT(RT_DEBUG_TRACE, ("Set failed!!(WPAPSK=%s), WPAPSK key-string required 8 ~ 64 characters \n", arg));
		return FALSE;
	}

	if (strlen(arg) == 64)
	{
		AtoH(arg, keyMaterial, 32);
		NdisMoveMemory(pAdapter->StaCfg.PskKey.Key, keyMaterial, 32);
		NdisMoveMemory(pAdapter->ApCfg.PMK, keyMaterial, 32);
	}
	else
	{
		PasswordHash((char *)arg, pAdapter->MlmeAux.Ssid, pAdapter->MlmeAux.SsidLen, keyMaterial);
		NdisMoveMemory(pAdapter->StaCfg.PskKey.Key, keyMaterial, 32);
		NdisMoveMemory(pAdapter->ApCfg.PMK, keyMaterial, 32);
	}

	RTMPMakeRSNIE(pAdapter, pAdapter->CommonCfg.AuthMode, pAdapter->CommonCfg.WepStatus);

	if(pAdapter->StaCfg.BssType == BSS_ADHOC &&\
	   pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPANone)
	{
		//RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_ADD_KEY, TRUE, &Key, sizeof(Key));
		Status = RTMPWPANoneAddKeyProc(pAdapter, &keyMaterial[0]);

		if (Status != NDIS_STATUS_SUCCESS)
			return FALSE;

		pAdapter->StaCfg.WpaState = SS_NOTUSE;
	}
	else	// Use RaConfig as PSK agent.
	{
		// Start STA supplicant state machine
		pAdapter->StaCfg.WpaState = SS_START;
	}

	return TRUE;
}

/*
	==========================================================================
	Description:
		Reset statistics counter

	Arguments:
		pAdapter			Pointer to our adapter
		arg

	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT	Set_ResetStatCounter_Proc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, ("==>Set_ResetStatCounter_Proc\n"));

	// add the most up-to-date h/w raw counters into software counters
	NICUpdateRawCounters(pAd);

	NdisZeroMemory(&pAd->WlanCounters, sizeof(COUNTER_802_11));
	NdisZeroMemory(&pAd->Counters8023, sizeof(COUNTER_802_3));
	NdisZeroMemory(&pAd->RalinkCounters, sizeof(COUNTER_RALINK));

	return TRUE;
}

/*
	==========================================================================
	Description:
		Set Power Saving mode
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_PSMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	if (pAdapter->OpMode == OPMODE_AP)
		return FALSE;

	if (pAdapter->StaCfg.BssType == BSS_INFRA)
	{
		if ((strcmp(arg, "MAX_PSP") == 0) || (strcmp(arg, "max_psp") == 0))
		{
			// do NOT turn on PSM bit here, wait until MlmeCheckForPsmChange()
			// to exclude certain situations.
			//	   MlmeSetPsmBit(pAdapter, PWR_SAVE);
			if (pAdapter->StaCfg.bWindowsACCAMEnable == FALSE)
				pAdapter->StaCfg.WindowsPowerMode = Ndis802_11PowerModeMAX_PSP;
			pAdapter->StaCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeMAX_PSP;
			OPSTATUS_SET_FLAG(pAdapter, fOP_STATUS_RECEIVE_DTIM);
			pAdapter->StaCfg.DefaultListenCount = 5;

		}
		else if ((strcmp(arg, "Fast_PSP") == 0) || (strcmp(arg, "fast_psp") == 0) ||
				 (strcmp(arg, "FAST_PSP") == 0))
		{
			// do NOT turn on PSM bit here, wait until MlmeCheckForPsmChange()
			// to exclude certain situations.
			//	   MlmeSetPsmBit(pAdapter, PWR_SAVE);
			OPSTATUS_SET_FLAG(pAdapter, fOP_STATUS_RECEIVE_DTIM);
			if (pAdapter->StaCfg.bWindowsACCAMEnable == FALSE)
				pAdapter->StaCfg.WindowsPowerMode = Ndis802_11PowerModeFast_PSP;
			pAdapter->StaCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeFast_PSP;
			pAdapter->StaCfg.DefaultListenCount = 3;
		}
		else
		{
			//Default Ndis802_11PowerModeCAM
			// clear PSM bit immediately
			MlmeSetPsmBit(pAdapter, PWR_ACTIVE);
			OPSTATUS_SET_FLAG(pAdapter, fOP_STATUS_RECEIVE_DTIM);
			if (pAdapter->StaCfg.bWindowsACCAMEnable == FALSE)
				pAdapter->StaCfg.WindowsPowerMode = Ndis802_11PowerModeCAM;
			pAdapter->StaCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeCAM;
		}

		DBGPRINT(RT_DEBUG_TRACE, ("Set_PSMode_Proc::(PSMode=%d)\n", pAdapter->StaCfg.WindowsPowerMode));
	}
	else
		return FALSE;


	return TRUE;
}

/*
	==========================================================================
	Description:
		Set operation mode. 0:Station mode, 1:Ap mode.
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
*/
INT Set_OpMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			arg)
{
	BOOLEAN OpMode;

	OpMode = (BOOLEAN)(simple_strtol(arg, 0, 10) > 0 ? OPMODE_AP : OPMODE_STA);

	if (OpMode != pAdapter->OpMode)
	{
		pAdapter->OpMode = OpMode;
		RTMPOPModeSwitching(pAdapter);
	}

	return TRUE;
}

#ifdef DBG
/*
	==========================================================================
	Description:
		Read / Write BBP
	Arguments:
		pAdapter					Pointer to our adapter
		wrq 						Pointer to the ioctl argument

	Return Value:
		None

	Note:
		Usage:
			   1.) iwpriv rausb0 bbp			   ==> read all BBP
			   2.) iwpriv rausb0 bbp 1			   ==> read BBP where RegID=1
			   3.) iwpriv rausb0 bbp 1=10		   ==> write BBP R1=0x10
	==========================================================================
*/
VOID RTMPIoctlBBP(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR				*this_char;
	CHAR				*value;
	UCHAR				regBBP;
	CHAR				msg[2048];
	CHAR				arg[255];
	LONG				bbpId;
	LONG				bbpValue;
	BOOLEAN				bIsPrintAllBBP = FALSE;
	INT 				Status = 0;

	DBGPRINT(RT_DEBUG_INFO, ("==>RTMPIoctlBBP\n"));

	memset(msg, 0x00, 2048);
	if (wrq->u.data.length > 1) //No parameters.
	{
		Status = copy_from_user(arg, wrq->u.data.pointer, (wrq->u.data.length > 255) ? 255 : wrq->u.data.length);
		sprintf(msg, "\n");

		//Parsing Read or Write
		this_char = arg;
		DBGPRINT(RT_DEBUG_INFO, ("this_char=%s\n", this_char));
		if (!*this_char)
			goto next;

		if ((value = rtstrchr(this_char, '=')) != NULL)
			*value++ = 0;

		if (!value || !*value)
		{ //Read
			DBGPRINT(RT_DEBUG_INFO, ("this_char=%s, value=%s\n", this_char, value));
			if (sscanf(this_char, "%d", &(bbpId)) == 1)
			{
				if (bbpId <= 108)
				{
					RTUSBReadBBPRegister(pAdapter, bbpId, &regBBP);
					sprintf(msg+strlen(msg), "R%02d[0x%02X]:%02X  ", bbpId, bbpId*2, regBBP);
					DBGPRINT(RT_DEBUG_INFO, ("msg=%s\n", msg));
				}
				else
				{//Invalid parametes, so default printk all bbp
					bIsPrintAllBBP = TRUE;
					goto next;
				}
			}
			else
			{ //Invalid parametes, so default printk all bbp
				bIsPrintAllBBP = TRUE;
				goto next;
			}
		}
		else
		{ //Write
			DBGPRINT(RT_DEBUG_INFO, ("this_char=%s, value=%s\n", this_char, value));
			if ((sscanf(this_char, "%d", &(bbpId)) == 1) && (sscanf(value, "%x", &(bbpValue)) == 1))
			{
				DBGPRINT(RT_DEBUG_INFO, ("bbpID=%02d, value=0x%x\n", bbpId, bbpValue));
				if (bbpId <= 108)
				{
					RTUSBWriteBBPRegister(pAdapter, (UCHAR)bbpId,(UCHAR) bbpValue);
					//Read it back for showing
					RTUSBReadBBPRegister(pAdapter, bbpId, &regBBP);
					sprintf(msg+strlen(msg), "R%02d[0x%02X]:%02X\n", bbpId, bbpId*2, regBBP);
					DBGPRINT(RT_DEBUG_INFO, ("msg=%s\n", msg));
				}
				else
				{//Invalid parametes, so default printk all bbp
					bIsPrintAllBBP = TRUE;
					goto next;
				}
			}
			else
			{ //Invalid parametes, so default printk all bbp
				bIsPrintAllBBP = TRUE;
				goto next;
			}
		}
	}
	else
		bIsPrintAllBBP = TRUE;

next:
	if (bIsPrintAllBBP)
	{
		memset(msg, 0x00, 2048);
		sprintf(msg, "\n");
		for (bbpId = 0; bbpId <= 108; bbpId++)
		{
			RTUSBReadBBPRegister(pAdapter, bbpId, &regBBP);
			sprintf(msg+strlen(msg), "R%02d[0x%02X]:%02X	", bbpId, bbpId*2, regBBP);
			if (bbpId%5 == 4)
				sprintf(msg+strlen(msg), "\n");
		}
		// Copy the information into the user buffer
		DBGPRINT(RT_DEBUG_TRACE, ("strlen(msg)=%d\n", strlen(msg)));
		wrq->u.data.length = strlen(msg);
		Status = copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	}
	else
	{
		DBGPRINT(RT_DEBUG_INFO, ("copy to user [msg=%s]\n", msg));
		// Copy the information into the user buffer
		DBGPRINT(RT_DEBUG_INFO, ("strlen(msg) =%d\n", strlen(msg)));
		wrq->u.data.length = strlen(msg);
		Status =  copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	}
	DBGPRINT(RT_DEBUG_TRACE, ("<==RTMPIoctlBBP\n\n"));
}

/*
	==========================================================================
	Description:
		Read / Write MAC
	Arguments:
		pAdapter					Pointer to our adapter
		wrq 						Pointer to the ioctl argument

	Return Value:
		None

	Note:
		Usage:
			   1.) iwpriv rausb0 mac 0		  ==> read MAC where Addr=0x0
			   2.) iwpriv rausb0 mac 0=12	  ==> write MAC where Addr=0x0, value=12
	==========================================================================
*/
VOID RTMPIoctlMAC(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR				*this_char;
	CHAR				*value;
	INT					j = 0, k = 0;
	CHAR				msg[1024];
	CHAR				arg[255];
	ULONG				macAddr = 0;
	UCHAR				temp[16], temp2[16];
	ULONG				macValue;
	INT 				Status = 0;

	DBGPRINT(RT_DEBUG_INFO, ("==>RTMPIoctlMAC\n"));
	memset(msg, 0x00, 1024);
	if (wrq->u.data.length > 1) //No parameters.
	{
		Status = copy_from_user(arg, wrq->u.data.pointer, (wrq->u.data.length > 255) ? 255 : wrq->u.data.length);
		sprintf(msg, "\n");

		//Parsing Read or Write
		this_char = arg;
		DBGPRINT(RT_DEBUG_INFO, ("this_char=%s\n", this_char));
		if (!*this_char)
			goto next;

		if ((value = rtstrchr(this_char, '=')) != NULL)
			*value++ = 0;

		if (!value || !*value)
		{ //Read
			DBGPRINT(RT_DEBUG_INFO, ("Read: this_char=%s, strlen=%d\n", this_char, strlen(this_char)));

			// Sanity check
			if(strlen(this_char) > 4)
				goto next;

			j = strlen(this_char);
			while(j-- > 0)
			{
				if(this_char[j] > 'f' || this_char[j] < '0')
					return;
			}

			// Mac Addr
			k = j = strlen(this_char);
			while(j-- > 0)
			{
				this_char[4-k+j] = this_char[j];
			}

			while(k < 4)
				this_char[3-k++]='0';
			this_char[4]='\0';

			if(strlen(this_char) == 4)
			{
				AtoH(this_char, temp, 4);
				macAddr = *temp*256 + temp[1];
				if (macAddr < 0xFFFF)
				{
					RTUSBReadMACRegister(pAdapter, macAddr, &macValue);
					DBGPRINT(RT_DEBUG_TRACE, ("MacAddr=%x, MacValue=%x\n", macAddr, macValue));
					sprintf(msg+strlen(msg), "[0x%08X]:%08X  ", macAddr , macValue);
					DBGPRINT(RT_DEBUG_INFO, ("msg=%s\n", msg));
				}
				else
				{//Invalid parametes, so default printk all bbp
					goto next;
				}
			}
		}
		else
		{ //Write
			DBGPRINT(RT_DEBUG_INFO, ("Write: this_char=%s, strlen(value)=%d, value=%s\n", this_char, strlen(value), value));
			memcpy(&temp2, value, strlen(value));
			temp2[strlen(value)] = '\0';

			// Sanity check
			if((strlen(this_char) > 4) || strlen(temp2) > 8)
				goto next;

			j = strlen(this_char);
			while(j-- > 0)
			{
				if(this_char[j] > 'f' || this_char[j] < '0')
					return;
			}

			j = strlen(temp2);
			while(j-- > 0)
			{
				if(temp2[j] > 'f' || temp2[j] < '0')
					return;
			}

			//MAC Addr
			k = j = strlen(this_char);
			while(j-- > 0)
			{
				this_char[4-k+j] = this_char[j];
			}

			while(k < 4)
				this_char[3-k++]='0';
			this_char[4]='\0';

			//MAC value
			k = j = strlen(temp2);
			while(j-- > 0)
			{
				temp2[8-k+j] = temp2[j];
			}

			while(k < 8)
				temp2[7-k++]='0';
			temp2[8]='\0';

			{
				AtoH(this_char, temp, 4);
				macAddr = *temp*256 + temp[1];

				AtoH(temp2, temp, 8);
				macValue = *temp*256*256*256 + temp[1]*256*256 + temp[2]*256 + temp[3];

				// debug mode
				if (macAddr == (HW_DEBUG_SETTING_BASE + 4))
				{
					// 0x2bf4: byte0 non-zero: enable R17 tuning, 0: disable R17 tuning
					if (macValue & 0x000000ff)
					{
						pAdapter->BbpTuning.bEnable = TRUE;
						DBGPRINT(RT_DEBUG_TRACE, ("turn on R17 tuning\n"));
					}
					else
					{
						UCHAR R17;
						pAdapter->BbpTuning.bEnable = FALSE;
						if (pAdapter->CommonCfg.Channel > 14)
							R17 = pAdapter->BbpTuning.R17LowerBoundA;
						else
							R17 = pAdapter->BbpTuning.R17LowerBoundG;
						RTUSBWriteBBPRegister(pAdapter, 17, R17);
						DBGPRINT(RT_DEBUG_TRACE, ("turn off R17 tuning, restore to 0x%02x\n", R17));
					}
					return;
				}

				DBGPRINT(RT_DEBUG_TRACE, ("MacAddr=%02x, MacValue=0x%x\n", macAddr, macValue));

				RTUSBWriteMACRegister(pAdapter, macAddr, macValue);
				sprintf(msg+strlen(msg), "[0x%08X]:%08X  ", macAddr, macValue);
				DBGPRINT(RT_DEBUG_INFO, ("msg=%s\n", msg));
			}
		}
	}
next:
	if(strlen(msg) == 1)
		sprintf(msg+strlen(msg), "===>Error command format!");
	DBGPRINT(RT_DEBUG_INFO, ("copy to user [msg=%s]\n", msg));
	// Copy the information into the user buffer
	DBGPRINT(RT_DEBUG_INFO, ("strlen(msg) =%d\n", strlen(msg)));
	wrq->u.data.length = strlen(msg);
	Status = copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);

	DBGPRINT(RT_DEBUG_TRACE, ("<==RTMPIoctlMAC\n\n"));
}

#endif //#ifdef DBG

/*
	==========================================================================
	Description:
		Read statistics counter
Arguments:
	pAdapter					Pointer to our adapter
	wrq 						Pointer to the ioctl argument

	Return Value:
		None

	Note:
		Usage:
			   1.) iwpriv rausb0 stat 0 		==> Read statistics counter
	==========================================================================
*/
VOID RTMPIoctlStatistics(
	IN	PRTMP_ADAPTER	pAd,
	IN	struct iwreq	*wrq)
{
	char				msg[1600];
	INT 				Status=0;

	memset(msg, 0x00, 1600);
	sprintf(msg, "\n");

	sprintf(msg+strlen(msg), "Tx success                      = %d\n", (ULONG)pAd->WlanCounters.TransmittedFragmentCount.QuadPart);
	sprintf(msg+strlen(msg), "Tx success without retry        = %d\n", (ULONG)pAd->WlanCounters.TransmittedFragmentCount.QuadPart - (ULONG)pAd->WlanCounters.RetryCount.QuadPart);
	sprintf(msg+strlen(msg), "Tx success after retry          = %d\n", (ULONG)pAd->WlanCounters.RetryCount.QuadPart);
	sprintf(msg+strlen(msg), "Tx fail to Rcv ACK after retry  = %d\n", (ULONG)pAd->WlanCounters.FailedCount.QuadPart);
	sprintf(msg+strlen(msg), "RTS Success Rcv CTS             = %d\n", (ULONG)pAd->WlanCounters.RTSSuccessCount.QuadPart);
	sprintf(msg+strlen(msg), "RTS Fail Rcv CTS                = %d\n", (ULONG)pAd->WlanCounters.RTSFailureCount.QuadPart);

	sprintf(msg+strlen(msg), "Rx success                      = %d\n", (ULONG)pAd->WlanCounters.ReceivedFragmentCount.QuadPart);
	sprintf(msg+strlen(msg), "Rx with CRC                     = %d\n", (ULONG)pAd->WlanCounters.FCSErrorCount.QuadPart);
	sprintf(msg+strlen(msg), "Rx drop due to out of resource  = %d\n", (ULONG)pAd->Counters8023.RxNoBuffer);
	sprintf(msg+strlen(msg), "Rx duplicate frame              = %d\n", (ULONG)pAd->WlanCounters.FrameDuplicateCount.QuadPart);

	sprintf(msg+strlen(msg), "False CCA (one second)          = %d\n", (ULONG)pAd->RalinkCounters.OneSecFalseCCACnt);
	sprintf(msg+strlen(msg), "RSSI-A                          = %d\n", (LONG)(pAd->StaCfg.LastRssi - pAd->BbpRssiToDbmDelta));
//	sprintf(msg+strlen(msg), "RSSI-B (if available) 		  = %d\n\n", (LONG)(pAd->StaCfg.LastRssi2 - pAd->BbpRssiToDbmDelta)); /* fonchi todo. */

	// Copy the information into the user buffer
	DBGPRINT(RT_DEBUG_INFO, ("copy to user [msg=%s]\n", msg));
	wrq->u.data.length = strlen(msg);
	Status = copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);

	DBGPRINT(RT_DEBUG_TRACE, ("<==RTMPIoctlStatistics\n"));
}

/*
	==========================================================================
	Description:
		Parse encryption type
Arguments:
	pAdapter					Pointer to our adapter
	wrq 						Pointer to the ioctl argument

	Return Value:
		None

	Note:
	==========================================================================
*/
static CHAR *GetEncryptType(CHAR enc)
{
	if(enc == Ndis802_11WEPDisabled)
		return "NONE";
	if(enc == Ndis802_11WEPEnabled)
		return "WEP";
	if(enc == Ndis802_11Encryption2Enabled)
		return "TKIP";
	if(enc == Ndis802_11Encryption3Enabled)
		return "AES";
	else
		return "UNKNOW";
}

static CHAR *GetAuthMode(CHAR auth)
{
	if(auth == Ndis802_11AuthModeOpen)
		return "OPEN";
	if(auth == Ndis802_11AuthModeShared)
		return "SHARED";
	if(auth == Ndis802_11AuthModeWPA)
		return "WPA";
	if(auth == Ndis802_11AuthModeWPAPSK)
		return "WPA-PSK";
	if(auth == Ndis802_11AuthModeWPANone)
		return "WPANONE";
	if(auth == Ndis802_11AuthModeWPA2)
		return "WPA2";
	if(auth == Ndis802_11AuthModeWPA2PSK)
		return "WPA2-PSK";
	else
		return "UNKNOW";
}

/*
	==========================================================================
	Description:
		Get site survey results
	Arguments:
		pAdapter					Pointer to our adapter
		wrq 						Pointer to the ioctl argument

	Return Value:
		None

	Note:
		Usage:
				1.) UI needs to wait 4 seconds after issue a site survey command
				2.) iwpriv ra0 get_site_survey
				3.) UI needs to prepare at least 4096bytes to get the results
	==========================================================================
*/
#define	LINE_LEN	(8+8+36+20+12+12+12)	// Channel+RSSI+SSID+Bssid+WepStatus+AuthMode+NetworkType
VOID RTMPIoctlGetSiteSurvey(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR		*msg;
	INT 		i=0;
	INT 		Status=0;

	msg = (CHAR *) kmalloc(sizeof(CHAR)*((MAX_LEN_OF_BSS_TABLE)*LINE_LEN), MEM_ALLOC_FLAG);

    if (msg == NULL)
    {
        return;
    }

	memset(msg, 0 ,(MAX_LEN_OF_BSS_TABLE)*LINE_LEN );
	sprintf(msg,"%s","\n");
	sprintf(msg+strlen(msg),"%-8s%-8s%-36s%-20s%-12s%-12s%-12s\n",
	    "Channel", "RSSI", "SSID", "BSSID", "Enc", "Auth", "NetworkType");
	for (i=0;i<MAX_LEN_OF_BSS_TABLE;i++)
	{
		if( pAdapter->ScanTab.BssEntry[i].Channel==0)
		break;

		if((strlen(msg)+LINE_LEN ) >= ((MAX_LEN_OF_BSS_TABLE)*LINE_LEN) )
			break;

		sprintf(msg+strlen(msg),"%-8d", pAdapter->ScanTab.BssEntry[i].Channel);
		sprintf(msg+strlen(msg),"%-8d", pAdapter->ScanTab.BssEntry[i].Rssi - pAdapter->BbpRssiToDbmDelta);
        sprintf(msg+strlen(msg),"%-36s", pAdapter->ScanTab.BssEntry[i].Ssid);
		sprintf(msg+strlen(msg),"%02x:%02x:%02x:%02x:%02x:%02x   ",
			pAdapter->ScanTab.BssEntry[i].Bssid[0],
			pAdapter->ScanTab.BssEntry[i].Bssid[1],
			pAdapter->ScanTab.BssEntry[i].Bssid[2],
			pAdapter->ScanTab.BssEntry[i].Bssid[3],
			pAdapter->ScanTab.BssEntry[i].Bssid[4],
			pAdapter->ScanTab.BssEntry[i].Bssid[5]);
		sprintf(msg+strlen(msg),"%-12s",GetEncryptType(pAdapter->ScanTab.BssEntry[i].WepStatus));
		sprintf(msg+strlen(msg),"%-12s",GetAuthMode(pAdapter->ScanTab.BssEntry[i].AuthMode));
        if (pAdapter->ScanTab.BssEntry[i].BssType == BSS_ADHOC)
            sprintf(msg+strlen(msg),"%-12s\n", "Adhoc");
        else
		    sprintf(msg+strlen(msg),"%-12s\n", "Infra");
	}

	wrq->u.data.length = strlen(msg);
	Status = copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	kfree(msg);
}

NDIS_STATUS RTMPWPANoneAddKeyProc(
	IN	PRTMP_ADAPTER	pAd,
	IN	PVOID			pBuf)
{
	PNDIS_802_11_KEY		pKey;
	ULONG					KeyLen;
	ULONG					BufLen;
	NDIS_STATUS 			Status = NDIS_STATUS_SUCCESS;
	int 					i;

	KeyLen = 32;
	BufLen = sizeof(NDIS_802_11_KEY) + KeyLen - 1;

	pKey = kmalloc(BufLen, MEM_ALLOC_FLAG);
	if (pKey == NULL)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("RTMPWPANoneAddKeyProc() allocate memory failed \n"));
		Status = NDIS_STATUS_FAILURE;
		return	Status;
	}

	NdisZeroMemory(pKey, BufLen);
	pKey->Length = BufLen;
	pKey->KeyIndex	= 0x80000000;
	pKey->KeyLength = KeyLen;
	for (i=0; i<6; i++)
		pKey->BSSID[i] = 0xff;

	NdisMoveMemory(pKey->KeyMaterial, pBuf, 32);
	RTMPWPAAddKeyProc(pAd, pKey);
	kfree(pKey);

	return Status;
}

#if 1
INT RTMPIoctlSetAuth(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR	 arg[1];
	INT 	 Status = 0;

	if (wrq->u.data.length != 1)
	{
		Status = -EINVAL;
		return (Status);

	}
	else
	{
		Status = copy_from_user(arg, wrq->u.data.pointer, wrq->u.data.length);

		if (arg[0] == 1)
			pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeOpen;
		else if (arg[0] == 2)
			pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeShared;
		else if (arg[0] == 3)
			pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPAPSK;
		else if (arg[0] == 4)
			pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPA2PSK;
		else if (arg[0] == 5)
			pAdapter->CommonCfg.AuthMode = Ndis802_11AuthModeWPANone;
		else
		{
			Status = -EINVAL;
			return (Status);
		}
	}


	pAdapter->StaCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlSetAuth::(AuthMode=%d)\n", pAdapter->CommonCfg.AuthMode));

	return (Status);
}

INT RTMPIoctlSetEncryp(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR	 arg[1];
	INT 	 Status = 0;

	if (wrq->u.data.length != 1)
	{
		Status = -EINVAL;
		return (Status);
	}
	else
	{
		Status = copy_from_user(arg, wrq->u.data.pointer, wrq->u.data.length);

		if (arg[0] == 1)	// NONE
		{
			pAdapter->CommonCfg.WepStatus   = Ndis802_11WEPDisabled;
			pAdapter->CommonCfg.PairCipher  = Ndis802_11WEPDisabled;
			pAdapter->CommonCfg.GroupCipher = Ndis802_11WEPDisabled;
		}
		else if (arg[0] == 2)	// WEP
		{
			pAdapter->CommonCfg.WepStatus   = Ndis802_11WEPEnabled;
			pAdapter->CommonCfg.PairCipher  = Ndis802_11WEPEnabled;
			pAdapter->CommonCfg.GroupCipher = Ndis802_11WEPEnabled;

		}
		else if (arg[0] == 3)	// TKIP
		{
			pAdapter->CommonCfg.WepStatus   = Ndis802_11Encryption2Enabled;
			pAdapter->CommonCfg.PairCipher  = Ndis802_11Encryption2Enabled;
			pAdapter->CommonCfg.GroupCipher = Ndis802_11Encryption2Enabled;

		}
		else if (arg[0] == 4)	// AES
		{
			pAdapter->CommonCfg.WepStatus   = Ndis802_11Encryption3Enabled;
			pAdapter->CommonCfg.PairCipher  = Ndis802_11Encryption3Enabled;
			pAdapter->CommonCfg.GroupCipher = Ndis802_11Encryption3Enabled;

		}
		else
		{
			Status = -EINVAL;
			return (Status);
		}
	}


	RTMPMakeRSNIE(pAdapter, pAdapter->CommonCfg.AuthMode, pAdapter->CommonCfg.WepStatus);
//	RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_WEP_STATUS, TRUE, &(pAdapter->CommonCfg.WepStatus),
//							sizeof(pAdapter->CommonCfg.WepStatus));
	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlSetEncryp::(EncrypType=%d)\n", pAdapter->CommonCfg.WepStatus));

	return (Status);
}

INT RTMPIoctlSetWpapsk(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR			arg[128];
	UCHAR			keyMaterial[40];
	INT 			Status = 0;

	if ((pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPAPSK) &&\
		(pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPA2PSK) &&\
		(pAdapter->CommonCfg.AuthMode != Ndis802_11AuthModeWPANone) )
		return TRUE;	// do nothing

	Status = copy_from_user(arg, wrq->u.data.pointer, wrq->u.data.length);

	NdisZeroMemory(keyMaterial, 40);

	if ((wrq->u.data.length < 8) || (wrq->u.data.length > 64))
	{
		DBGPRINT(RT_DEBUG_TRACE, ("Set failed!!(WPAPSK=%s), WPAPSK key-string required 8 ~ 64 characters \n", arg));
		Status = -EINVAL;
		return (Status);
	}
	else if (wrq->u.data.length == 64)
	{
		AtoH(arg, keyMaterial, 32);
		NdisMoveMemory(pAdapter->StaCfg.PskKey.Key, keyMaterial, 32);
	}
	else
	{
		PasswordHash((char *)arg, pAdapter->MlmeAux.Ssid, pAdapter->MlmeAux.SsidLen, keyMaterial);
		NdisMoveMemory(pAdapter->StaCfg.PskKey.Key, keyMaterial, 32);
	}

	RTMPMakeRSNIE(pAdapter, pAdapter->CommonCfg.AuthMode, pAdapter->CommonCfg.WepStatus);

	if(pAdapter->StaCfg.BssType == BSS_ADHOC &&\
	   pAdapter->CommonCfg.AuthMode == Ndis802_11AuthModeWPANone)
	{
		//RTUSBEnqueueCmdFromNdis(pAdapter, OID_802_11_ADD_KEY, TRUE, &Key, sizeof(Key));
		Status = RTMPWPANoneAddKeyProc(pAdapter, &keyMaterial[0]);

		if (Status != NDIS_STATUS_SUCCESS)
			return -ENOMEM;

		pAdapter->StaCfg.WpaState = SS_NOTUSE;
	}
	else	 // Use RaConfig as PSK agent.
	{
		// Start STA supplicant state machine
		pAdapter->StaCfg.WpaState = SS_START;
	}

	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlSetWpapsk::(WPAPSK=%s)\n", arg));

	return (Status);
}

INT RTMPIoctlSetPsm(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	CHAR	 arg[1];
	INT 	 Status = 0;

	if (wrq->u.data.length != 1)
	{
		Status = -EINVAL;
		return (Status);
	}
	else
	{
		Status = copy_from_user(arg, wrq->u.data.pointer, wrq->u.data.length);

		if (arg[0] == 0)
		{
			//Default Ndis802_11PowerModeCAM
			// clear PSM bit immediately
			MlmeSetPsmBit(pAdapter, PWR_ACTIVE);
			OPSTATUS_SET_FLAG(pAdapter, fOP_STATUS_RECEIVE_DTIM);
			if (pAdapter->StaCfg.bWindowsACCAMEnable == FALSE)
				pAdapter->StaCfg.WindowsPowerMode = Ndis802_11PowerModeCAM;
			pAdapter->StaCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeCAM;
		}
		else if (arg[0] == 1)
		{
			// do NOT turn on PSM bit here, wait until MlmeCheckForPsmChange()
			// to exclude certain situations.
			//	   MlmeSetPsmBit(pAdapter, PWR_SAVE);
			if (pAdapter->StaCfg.bWindowsACCAMEnable == FALSE)
				pAdapter->StaCfg.WindowsPowerMode = Ndis802_11PowerModeMAX_PSP;
			pAdapter->StaCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeMAX_PSP;
			OPSTATUS_SET_FLAG(pAdapter, fOP_STATUS_RECEIVE_DTIM);
			pAdapter->StaCfg.DefaultListenCount = 5;

		}
		else if (arg[0] == 2)
		{
			// do NOT turn on PSM bit here, wait until MlmeCheckForPsmChange()
			// to exclude certain situations.
			//	   MlmeSetPsmBit(pAdapter, PWR_SAVE);
			OPSTATUS_SET_FLAG(pAdapter, fOP_STATUS_RECEIVE_DTIM);
			if (pAdapter->StaCfg.bWindowsACCAMEnable == FALSE)
				pAdapter->StaCfg.WindowsPowerMode = Ndis802_11PowerModeFast_PSP;
			pAdapter->StaCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeFast_PSP;
			pAdapter->StaCfg.DefaultListenCount = 3;
		}
		else
		{
			Status = -EINVAL;
			return (Status);
		}
	}


	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlSetPsm::(PSMode=%d)\n", pAdapter->StaCfg.WindowsPowerMode));
	return (Status);

}

VOID RTMPIoctlGetRaAPCfg(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
#if 0 /* fonchi todo. */
	pAdapter->PortCfg.bGetAPConfig = TRUE;
	EnqueueProbeRequest(pAdapter);
	DBGPRINT(RT_DEBUG_TRACE, ("RTMPIoctlGetRaAPCfg::(bGetAPConfig=%d)\n", pAdapter->PortCfg.bGetAPConfig));
#endif
	return;
}

#endif


static char * rtstrchr(const char * s, int c)
{
	for(; *s != (char) c; ++s)
		if (*s == '\0')
			return NULL;
	return (char *) s;
}

/*
 * Units are in db above the noise floor. That means the
 * rssi values reported in the tx/rx descriptors in the
 * driver are the SNR expressed in db.
 *
 * If you assume that the noise floor is -95, which is an
 * excellent assumption 99.5 % of the time, then you can
 * derive the absolute signal level (i.e. -95 + rssi).
 * There are some other slight factors to take into account
 * depending on whether the rssi measurement is from 11b,
 * 11g, or 11a.   These differences are at most 2db and
 * can be documented.
 *
 * NB: various calculations are based on the orinoco/wavelan
 *	   drivers for compatibility
 */
static void set_quality(PRTMP_ADAPTER pAdapter,
	struct iw_quality *iq,
	u_int rssi)
{
    u32 ChannelQuality, NorRssi;


    // Normalize Rssi
    if (rssi > 0x50)
        NorRssi = 100;
    else if (rssi  < 0x20)
        NorRssi = 0;
    else
        NorRssi = (rssi  - 0x20) * 2;

    // ChannelQuality = W1*RSSI + W2*TxPRR + W3*RxPER	 (RSSI 0..100), (TxPER 100..0), (RxPER 100..0)
    ChannelQuality = (RSSI_WEIGHTING * NorRssi +
					    TX_WEIGHTING * (100 - 0) +
				        RX_WEIGHTING* (100 - 0)) / 100;

    if (ChannelQuality >= 100)
        ChannelQuality = 100;

    iq->qual = ChannelQuality;

#ifdef RTMP_EMBEDDED
    iq->level = rt_abs(rssi);   // signal level (dBm)
#else
    iq->level = abs(rssi);      // signal level (dBm)
#endif
    iq->level += 256 - pAdapter->BbpRssiToDbmDelta;
    iq->noise = (pAdapter->BbpWriteLatch[17] > pAdapter->BbpTuning.R17UpperBoundG) ? pAdapter->BbpTuning.R17UpperBoundG : ((ULONG) pAdapter->BbpWriteLatch[17]); 	// noise level (dBm)
    iq->noise += 256 - 143;
    iq->updated = pAdapter->iw_stats.qual.updated;

}

