#ifndef __LITE_QMI_UIM_H__
#define __LITE_QMI_UIM_H__

#include "common.h"
#include "msgid.h"
#include "qmerrno.h"

#define MAX_USER_INPUT_SIZE  512

typedef enum _status_code 
{
    SUCCESS =  0,    // The operation succeeded.
    FAILURE = -1,    // The operation failed.    
} status_code, *pstatus_code;

enum AppStateType
{
    AppUninitialized,
    AppRunning,
    AppShuttingDown,
    AppCommandExecuted,

    AppGetEventRegister,
    AppSwitchSlot,
    AppVerifyPin,
    AppSetPinProtection,
    AppUnblockPin,
    AppRefereshOk,
    AppRefereshComplete,
    AppRefereshRegister,
    AppRefereshGetLastEvent,
    AppGetFileAttributes,
    AppGetConfigurationMask,
    AppChangePin,
};

#define ANSI_COLOR_RED     "\x1b[31m"
#define ANSI_COLOR_GREEN   "\x1b[32m"
#define ANSI_COLOR_YELLOW  "\x1b[33m"
#define ANSI_COLOR_BLUE    "\x1b[34m"
#define ANSI_COLOR_MAGENTA "\x1b[35m"
#define ANSI_COLOR_CYAN    "\x1b[36m"
#define ANSI_COLOR_RESET   "\x1b[0m"

#endif //__LITE_QMI_UIM_H__
