#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <QmiService.h>
#include <CtlService.h>
#include <QmiSyncObject.h>
#include "lite-qmi-wds.h"
#include "wds.h"

extern void DisplayGetApnMsisdnInfo(unpack_wds_ApnMsisdnInfo_t *pApnMsisdnInfo);
extern void DisplayLteAttachParamsIndication(unpack_wds_SLQSLteAttachParams_ind_t *pLteAttachParams_ind);
extern void DisplayApnOpReservedPcoListChangeIndication(unpack_wds_SLQSApnOpReservedPcoListChange_ind_t *pApnOpReservedPcoListChange_ind);
extern void DisplayApnMsisdnInfoChangeIndication(unpack_wds_SLQSApnMsisdnInfoChange_ind_t *pApnMsisdnInfoChange_ind);
extern void DisplayPdnThrottleInfoIndication(unpack_wds_SLQSPdnThrottleInfo_ind_t *pPdnThrottleInfo_ind);
extern void DisplayModemAssistedKaStatusIndication(unpack_wds_SLQSModemAssistedKaStatus_ind_t  *pModemAssistedKaStatus_ind);
extern void DisplayApnOpReservedPcoList(unpack_wds_ApnOpReservedPcoList_t *pApnOpReservedPcoListChange_ind);
extern void DisplayWdsEventReport(unpack_wds_SLQSSetWdsEventReport_ind_t *pWdsEventReport_ind);
extern void Display3GPPConfigItems(unpack_wds_SLQSGet3GPPConfigItem_t *pGet3GPPConfigItem);
extern void DisplayThroughputInformationInd(unpack_wds_ThroughputInformationInd_t  *pThroughputInformationInd);
extern void DisplayDownlinkThroughputInformationInd(unpack_wds_DLThroughputInformationInd_t  *pDLThroughputInfoInd);
extern void DisplayQueryDLThroughputReportingStatus(unpack_wds_QueryDLThroughputReportingStatusInd_t  *pQueryDLThroughputReportingStatusInd);
extern void DisplayGetCurrentChannelRate(unpack_wds_SLQSGetCurrentChannelRate_t *pCurrentChannelRate);

void SetKeepAliveDataSession(QmiService* pQmiService, const bool enableKA)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    uint8_t keepAliveDataSessionFlag = enableKA? 1 : 0;
    int ret = pack_wds_KeepAliveDataSession(&req_ctx, syncObject.buffer, &syncObject.bufferSize, keepAliveDataSessionFlag);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_KeepAliveDataSession returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_Keep_Alive_Data_Session_t unpackObject;
            ret = unpack_wds_KeepAliveDataSession((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_KeepAliveDataSession Tlvresult: %d Mask: 0x%8.8x\n", unpackObject.Tlvresult, *unpackObject.ParamPresenceMask.word);
			}
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_KeepAliveDataSession errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void ResetAndModifyProfileSettings(QmiService* pQmiService, uint8_t profileID, uint8_t profileType, wds_profileInfo *pProfile)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);

	pack_wds_ResetAndModifyProfileSettings_t resetAndModifyProfileSettings;
	resetAndModifyProfileSettings.ProfileId = profileID;
	resetAndModifyProfileSettings.ProfileType = profileType;
	resetAndModifyProfileSettings.pProfile = pProfile;
    int ret = pack_wds_ResetAndModifyProfileSettings(&req_ctx, syncObject.buffer, &syncObject.bufferSize, &resetAndModifyProfileSettings);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_ResetAndModifyProfileSettings returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_ResetAndModifyProfileSettings_t unpackObject;
            ret = unpack_wds_ResetAndModifyProfileSettings((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_ResetAndModifyProfileSettings Tlvresult: %d\n", unpackObject.Tlvresult);
			}
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_ResetAndModifyProfileSettings errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
                printf ("unpack_wds_ResetAndModifyProfileSettings extended_error_code: %d\n", unpackObject.extended_error_code);
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void GetApnOpReservedPcoList(QmiService* pQmiService, char *pApnName)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    pack_wds_GetApnOpReservedPcoList_t reqArg;
    reqArg.pApnName = pApnName;


    int ret = pack_wds_GetApnOpReservedPcoList(&req_ctx, syncObject.buffer, &syncObject.bufferSize, &reqArg);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_GetApnOpReservedPcoList returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_ApnOpReservedPcoList_t unpackObject;
            unpackObject.numInstances = 50;
            WdsApnOpReservedPco_t arrWdsApnOpReservedPcoList[50] = {{0,0,0,0,0,{0},0}};
            unpackObject.pWdsApnOpReservedPcoList = &arrWdsApnOpReservedPcoList[0];
            ret = unpack_wds_ApnOpReservedPcoList((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("GetApnOpReservedPcoListSettings  Count APN: %d result: %d\n", unpackObject.numInstances, ret);
                DisplayApnOpReservedPcoList(&unpackObject);
			}
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_ApnOpReservedPcoList errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void GetApnMsisdnInfo(QmiService* pQmiService, char *pApnName)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    pack_wds_GetApnMsisdnInfo_t reqParam;
    reqParam.pApnName = pApnName;

    int ret = pack_wds_GetApnMsisdnInfo(&req_ctx, syncObject.buffer, &syncObject.bufferSize, &reqParam);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_GetApnMsisdnInfo returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_ApnMsisdnInfo_t unpackObject;
            uint8_t   Msisdn[20] = {0};
            unpackObject.num_msisdn = 20;
            unpackObject.pMsisdn = &Msisdn[0];

            ret = unpack_wds_ApnMsisdnInfo((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_ApnMsisdnInfo MSISDN count: %d Tlvresult: %d\n", unpackObject.num_msisdn, ret);
                DisplayGetApnMsisdnInfo(&unpackObject);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_ApnMsisdnInfo errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void DeleteAllProfiles(QmiService* pQmiService, uint64_t ProfileTypeMask, uint64_t *pProfilePersistenceMask, uint64_t *pProfileClientTypeMask)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);

    int ret = pack_wds_DeleteAllProfiles(&req_ctx, syncObject.buffer, &syncObject.bufferSize, ProfileTypeMask, pProfilePersistenceMask, pProfileClientTypeMask);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_DeleteAllProfiles returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_delete_all_profiles_t unpackObject;
            ret = unpack_wds_DeleteAllProfiles((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("DeleteAllProfiles  Tlvresult: %d Mask: 0x%8.8x\n", unpackObject.Tlvresult, *unpackObject.ParamPresenceMask.word);

            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_DeleteAllProfiles errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void SetEhrpdFallbackApnList(QmiService* pQmiService, uint8_t fallback_apn_name_list_len, WdsEhrpdFallbackApn_t *pWdsEhrpdFallbackApn)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
	pack_wds_SetEhrpdFallbackApnList_t reqParam;
	reqParam.fallback_apn_name_list_len = fallback_apn_name_list_len;
	reqParam.pWdsEhrpdFallbackApn = pWdsEhrpdFallbackApn;

    int ret = pack_wds_SetEhrpdFallbackApnList(&req_ctx, syncObject.buffer, &syncObject.bufferSize, &reqParam);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SetEhrpdFallbackApnList returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SetDefaultProfile_t unpackObject;
            ret = unpack_wds_SetEhrpdFallbackApnList((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_SetEhrpdFallbackApnList  Tlvresult: %d\n", unpackObject.Tlvresult);

            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SetEhrpdFallbackApnList errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void SetModemAssistedKaStart(QmiService* pQmiService, pack_wds_modem_assisted_ka_start_t *pReqParam)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_ModemAssistedKaStart(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pReqParam);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SetEhrpdFallbackApnList returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_modem_assisted_ka_start_t unpackObject;
            ret = unpack_wds_ModemAssistedKaStart((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_ModemAssistedKaStart Tlvresult: %d keep_alive_handle: %d \n", ret,
                    unpackObject.keep_alive_handle);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_ModemAssistedKaStart errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void SetModemAssistedKaStop(QmiService* pQmiService, uint32_t  KeepAliveHandle)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_ModemAssistedKaStop(&req_ctx, syncObject.buffer, &syncObject.bufferSize, KeepAliveHandle);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_ModemAssistedKaStop returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_modem_assisted_ka_stop_t unpackObject;
            ret = unpack_wds_ModemAssistedKaStop((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("SetModemAssistedKaStop Tlvresult: %d Mask: 0x%8.8x\n", 
                                            unpackObject.Tlvresult, *unpackObject.ParamPresenceMask.word);

            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_ModemAssistedKaStop errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}


void GetEhrpdFallbackApnList(QmiService* pQmiService)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_GetEhrpdFallbackApnList(&req_ctx, syncObject.buffer, &syncObject.bufferSize);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_GetEhrpdFallbackApnList returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            uint8_t   fallback_apn_name_list_len = 10;
            WdsEhrpdFallbackApn_t WdsEhrpdFallbackApn[fallback_apn_name_list_len];

            unpack_wds_GetEhrpdFallbackApnList_t unpackObject;
            memset(&unpackObject, 0, sizeof(unpack_wds_GetEhrpdFallbackApnList_t));
            unpackObject.fallback_apn_name_list_len = fallback_apn_name_list_len;
            unpackObject.pWdsEhrpdFallbackApn = &WdsEhrpdFallbackApn[0];

            ret = unpack_wds_GetEhrpdFallbackApnList((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("GetEhrpdFallbackApnList fallback_apn_name_list_len: %d Tlvresult: %d\n", 
                                    unpackObject.fallback_apn_name_list_len, unpackObject.Tlvresult);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("GetEhrpdFallbackApnList errorCode: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

extern void RegisterWdsEventRegister(QmiService* pQmiService, pack_wds_SLQSWdsSetEventReport_t *pReqArg)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SLQSWdsSetEventReport(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pReqArg);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SLQSWdsSetEventReport returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SLQSWdsSetEventReport_t unpackObject;
            ret = unpack_wds_SLQSWdsSetEventReport((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_SLQSWdsSetEventReport: Mask: 0x%8.8x\n", *unpackObject.ParamPresenceMask.word);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SLQSWdsSetEventReport: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void RegisterWdsIndicationRegister(QmiService* pQmiService, pack_wds_indication_register_t   *pReqArg)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_IndicationRegister(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pReqArg);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_IndicationRegister returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_IndicationRegister_t unpackObject;
            ret = unpack_wds_IndicationRegister((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_IndicationRegister: Mask: 0x%8.8x\n", *unpackObject.ParamPresenceMask.word);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_IndicationRegister: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void GetDefaultProfileId(QmiService* pQmiService, pack_wds_GetDefaultProfileNum_t   *pReqArg)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_GetDefaultProfileNum(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pReqArg);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_GetDefaultProfileNum returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_GetDefaultProfileNum_t unpackObject;
            ret = unpack_wds_GetDefaultProfileNum((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("Default Profile ID: %d\n", unpackObject.index);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_GetDefaultProfileNum: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void SetDefaultProfileId(QmiService* pQmiService, pack_wds_SetDefaultProfileNum_t   *pReqArg)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SetDefaultProfileNum(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pReqArg);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SetDefaultProfileNum returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SetDefaultProfileNum_t unpackObject;
            ret = unpack_wds_SetDefaultProfileNum((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_SetDefaultProfileNum: Mask: 0x%8.8x\n", *unpackObject.ParamPresenceMask.word);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SetDefaultProfileNum: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void Get3GPPConfigItems(QmiService* pQmiService)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SLQSGet3GPPConfigItem(&req_ctx, syncObject.buffer, &syncObject.bufferSize);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SLQSGet3GPPConfigItem returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SLQSGet3GPPConfigItem_t unpackObject;
            memset(&unpackObject, 0, sizeof(unpack_wds_SLQSGet3GPPConfigItem_t));
            unpackObject.LTEAttachProfileListLen = MAX_WDS_3GPP_CONF_LTE_ATTACH_PROFILE_LIST_SIZE;

            ret = unpack_wds_SLQSGet3GPPConfigItem((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                Display3GPPConfigItems(&unpackObject);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SLQSGet3GPPConfigItem: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void Set3GPPConfigItems(QmiService* pQmiService, pack_wds_SLQSSet3GPPConfigItem_t *pSet3GPPConfigItem)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SLQSSet3GPPConfigItem(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pSet3GPPConfigItem);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SLQSSet3GPPConfigItem returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SLQSSet3GPPConfigItem_t unpackObject;
            memset(&unpackObject, 0, sizeof(unpack_wds_SLQSSet3GPPConfigItem_t));

            ret = unpack_wds_SLQSSet3GPPConfigItem((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_SLQSSet3GPPConfigItem: Mask: 0x%8.8x\n", *unpackObject.ParamPresenceMask.word);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SLQSSet3GPPConfigItem: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}

    QmiSyncObject_Destroy(&syncObject);
}

void SetDownlinkThroughputReportPeriod(QmiService* pQmiService, pack_wds_SetDLThroughputReportPeriod_t *pSetDLThroughputReportPeriod)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SLQSSetDLThroughputReportPeriod(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pSetDLThroughputReportPeriod);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SLQSSetDLThroughputReportPeriod returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SetDLThroughputReportPeriod_t unpackObject;
            memset(&unpackObject, 0, sizeof(unpack_wds_SetDLThroughputReportPeriod_t));

            ret = unpack_wds_SLQSSetDLThroughputReportPeriod((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                printf("unpack_wds_SLQSSetDLThroughputReportPeriod: Mask: 0x%8.8x\n", *unpackObject.ParamPresenceMask.word);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SLQSSetDLThroughputReportPeriod: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}
    QmiSyncObject_Destroy(&syncObject);
}

void QueryDownlinkThroughputReportingStatus(QmiService* pQmiService)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SLQSQueryDLThroughputReportingStatus(&req_ctx, syncObject.buffer, &syncObject.bufferSize);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SLQSQueryDLThroughputReportingStatus returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_QueryDLThroughputReportingStatus_t unpackObject;
            memset(&unpackObject, 0, sizeof(unpack_wds_QueryDLThroughputReportingStatus_t));

            uint32_t  reporting_status = 0;
            uint32_t  actual_interval = 0;
            unpackObject.pReporting_status = &reporting_status;
            unpackObject.pActual_interval = &actual_interval;

            ret = unpack_wds_SLQSQueryDLThroughputReportingStatus((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                DisplayQueryDLThroughputReportingStatus(&unpackObject);
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SLQSQueryDLThroughputReportingStatus: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}
    QmiSyncObject_Destroy(&syncObject);
}

extern void GetCurrentChannelRate(QmiService* pQmiService)
{
    pack_qmi_t  req_ctx;
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
    int ret = pack_wds_SLQSSwiGetCurrentChannelRate(&req_ctx, syncObject.buffer, &syncObject.bufferSize);

    if(ret != eQCWWAN_ERR_NONE)
    {
   		printf (ANSI_COLOR_RED);
		printf ("pack_wds_SLQSSwiGetCurrentChannelRate returned error %d\n", ret);
		printf (ANSI_COLOR_RESET);
        QmiSyncObject_Destroy(&syncObject);
		return;
    }
    QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(pQmiService, 
                                 req_ctx.xid, 
                                 syncObject.buffer, 
                                 syncObject.bufferSize, 
                                 QmiSyncObject_ResponseCallback, 
                                 (void*)&syncObject
                                 );

	if (ret != SUCCESS)
	{
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			printf("Function timed out");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            unpack_wds_SLQSGetCurrentChannelRate_t unpackObject;
            memset(&unpackObject, 0, sizeof(unpack_wds_SLQSGetCurrentChannelRate_t));

            ret = unpack_wds_SLQSSwiGetCurrentChannelRate((uint8_t*)syncObject.buffer, syncObject.bufferSize, &unpackObject);
            
            if (ret == eQCWWAN_ERR_NONE)
			{	
				printf (ANSI_COLOR_GREEN);
                DisplayGetCurrentChannelRate(&unpackObject);                
            }
			else
			{
				printf (ANSI_COLOR_RED);
				printf ("unpack_wds_SLQSSwiGetCurrentChannelRate: %d - %s\n", ret, helper_get_error_reason(ret));
			}
			printf (ANSI_COLOR_RESET);
		}
	}
    QmiSyncObject_Destroy(&syncObject);
}

void wds_indication_handler(uint16_t msgid, uint8_t *qmiData, uint32_t qmiDataSize)
{
    int rtn = 0;

    switch (msgid)
    {
        case eQMI_WDS_EVENT_REPORT_IND:
        {
            unpack_wds_SLQSSetWdsEventReport_ind_t sWdsEventReport_ind;
            memset(&sWdsEventReport_ind, 0, sizeof(unpack_wds_SLQSSetWdsEventReport_ind_t));

            rtn = unpack_wds_SLQSSetWdsEventReport_ind(qmiData, qmiDataSize, &sWdsEventReport_ind);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);
                printf("unpack_wds_SLQSSetWdsEventReport_ind errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
                DisplayWdsEventReport(&sWdsEventReport_ind);
            }
        }
        break;
        case eQMI_WDS_LTE_ATTACH_PARAMS_IND:
        {
	        unpack_wds_SLQSLteAttachParams_ind_t   sLteAttachParams_ind;
            eQMI_WDS_IP_TYPE_t Ip_Type;
            uint32_t IPv4Address;
            uint32_t IPv4GatewayAddress;
            uint32_t IPv4SubnetMask;
            IPv6AddressTlv_t Ipv6Address;
            IPv6AddressTlv_t Ipv6GatewayAddress;

            sLteAttachParams_ind.AttachParamValidTlv = 0;
            sLteAttachParams_ind.ApnStringLen = 100;
            char ApnString[100] = {0};
            sLteAttachParams_ind.pApnString = &ApnString[0];
            sLteAttachParams_ind.pIp_Type = &Ip_Type;
            sLteAttachParams_ind.pIPv4Address = &IPv4Address;
            sLteAttachParams_ind.pIPv4GatewayAddress = &IPv4GatewayAddress;
            sLteAttachParams_ind.pIPv4SubnetMask = &IPv4SubnetMask;
            sLteAttachParams_ind.pIpv6Address = &Ipv6Address;
            sLteAttachParams_ind.pIpv6GatewayAddress = &Ipv6GatewayAddress;
            swi_uint256_init(&sLteAttachParams_ind.ParamPresenceMask);

            rtn = unpack_wds_SLQSLteAttachParams_ind(qmiData, qmiDataSize, &sLteAttachParams_ind);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);
                printf("unpack_wds_SLQSLteAttachParams_ind errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
                DisplayLteAttachParamsIndication(&sLteAttachParams_ind);
            }
        }   
        break;
        case eQMI_WDS_APN_OP_RESERVED_PCO_LIST_CHANGE_IND:
        {
	        unpack_wds_SLQSApnOpReservedPcoListChange_ind_t sApnOpReservedPcoListChange_ind;
            sApnOpReservedPcoListChange_ind.PcoInfoLength = 10;
	        WdsApnOpReservedPco_t WdsApnOpReservedPcoList[10];
            sApnOpReservedPcoListChange_ind.pWdsApnOpReservedPcoList = &WdsApnOpReservedPcoList[0];
            rtn = unpack_wds_SLQSApnOpReservedPcoListChange_ind(qmiData, qmiDataSize, &sApnOpReservedPcoListChange_ind);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);
                printf("unpack_wds_SLQSLteAttachParams_ind errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayApnOpReservedPcoListChangeIndication(&sApnOpReservedPcoListChange_ind);
            }
        }
        break;
        case eQMI_WDS_APN_MSISDN_INFO_CHANGE_IND:
        {
	        unpack_wds_SLQSApnMsisdnInfoChange_ind_t        sApnMsisdnInfoChange_ind;
            memset(&sApnMsisdnInfoChange_ind, 0, sizeof(unpack_wds_SLQSApnMsisdnInfoChange_ind_t));
            sApnMsisdnInfoChange_ind.msisdn_len = 20;
            uint8_t  Msisdn[20] = {0};
            sApnMsisdnInfoChange_ind.pMsisdn = &Msisdn[0];

            rtn = unpack_wds_SLQSApnMsisdnInfoChange_ind(qmiData, qmiDataSize, &sApnMsisdnInfoChange_ind);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);                
                printf("unpack_wds_SLQSLteAttachParams_ind errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayApnMsisdnInfoChangeIndication(&sApnMsisdnInfoChange_ind);
            }
        }            
        break;
        case eQMI_WDS_PDN_THROTTLE_INFO_IND:
        {
	        unpack_wds_SLQSPdnThrottleInfo_ind_t   sPdnThrottleInfo_ind;
           	sPdnThrottleInfo_ind.throttle_info_len = 10;
            sPdnThrottleInfo_ind.throttle_info_ext_len = 10;
            sPdnThrottleInfo_ind.throttle_info_addn_params_len = 10;
            WdsPDNThrottleInformationTlv_t    PDNThrottleInformation[10];
            WdsExtPDNThrottleInformationTlv_t ExtPDNThrottleInformationList[10];
            WdsAddPDNThrottleInformationTlv_t AddPDNThrottleInformationList[10];
            sPdnThrottleInfo_ind.pPDNThrottleInformation = &PDNThrottleInformation[0];
            sPdnThrottleInfo_ind.pExtPDNThrottleInformationList = &ExtPDNThrottleInformationList[0];
            sPdnThrottleInfo_ind.pAddPDNThrottleInformationList = &AddPDNThrottleInformationList[0];
            swi_uint256_init(&sPdnThrottleInfo_ind.ParamPresenceMask);

            rtn = unpack_wds_SLQSPdnThrottleInfo_ind(qmiData, qmiDataSize, &sPdnThrottleInfo_ind);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);                
                printf("unpack_wds_SLQSLteAttachParams_ind errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayPdnThrottleInfoIndication(&sPdnThrottleInfo_ind);
            }
        }
        break;
        case eQMI_WDS_MODEM_ASSISTED_KA_STATUS_IND:
        {
	        unpack_wds_SLQSModemAssistedKaStatus_ind_t      sModemAssistedKaStatus_ind;
            rtn = unpack_wds_SLQSModemAssistedKaStatus_ind(qmiData, qmiDataSize, &sModemAssistedKaStatus_ind);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);                
                printf("unpack_wds_SLQSLteAttachParams_ind errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayModemAssistedKaStatusIndication(&sModemAssistedKaStatus_ind);
            }
        }            
        break;
        case eQMI_WDS_THROUGHPUT_INFO_IND:
        {
	        unpack_wds_ThroughputInformationInd_t  sThroughputInformationInd;
            sThroughputInformationInd.throughput_info_len = 20;
            ThroughputInformationItem_t sThroughputInformationList[20];
            ThroughputInformationMac_t arrThroughputInformationMac[20][10];
            memset(arrThroughputInformationMac, 0, sizeof (arrThroughputInformationMac));
            sThroughputInformationInd.pThroughputInformationList = &sThroughputInformationList[0];
            for (int idx = 0; idx < sThroughputInformationInd.throughput_info_len; ++idx)
            {
                sThroughputInformationInd.pThroughputInformationList[idx].pThroughputInformationMac = arrThroughputInformationMac[idx]; 
            }

            rtn = unpack_wds_ThroughputInformationInd(qmiData, qmiDataSize, &sThroughputInformationInd);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);                
                printf("unpack_wds_ThroughputInformationInd errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayThroughputInformationInd(&sThroughputInformationInd);
            }
        }            
        break;
        case eQMI_WDS_DOWNLINK_THROUGHPUT_INFO_IND:
        {
	        unpack_wds_DLThroughputInformationInd_t  sDLThroughputInfoInd;
			memset(&sDLThroughputInfoInd, 0, sizeof(unpack_wds_DLThroughputInformationInd_t));

            uint32_t downlink_allowed_rate = 0;
            uint8_t  confidence_level = 0;
            uint8_t  is_suspended = 0;
            sDLThroughputInfoInd.pDownlink_allowed_rate = &downlink_allowed_rate;
            sDLThroughputInfoInd.pConfidence_level = &confidence_level;
            sDLThroughputInfoInd.pIs_suspended = &is_suspended;

            rtn = unpack_wds_DLThroughputInformationInd(qmiData, qmiDataSize, &sDLThroughputInfoInd);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);                
                printf("unpack_wds_DLThroughputInformationInd errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayDownlinkThroughputInformationInd(&sDLThroughputInfoInd);
            }
        }            
        break;
        case eQMI_WDS_DOWNLINK_THROUGHPUT_REPORTING_STATUS_IND:
        {
	        unpack_wds_QueryDLThroughputReportingStatusInd_t  sQueryDLThroughputReportingStatusInd;
			memset(&sQueryDLThroughputReportingStatusInd, 0, sizeof(unpack_wds_QueryDLThroughputReportingStatusInd_t));

            rtn = unpack_wds_QueryDLThroughputReportingStatusInd(qmiData, qmiDataSize, &sQueryDLThroughputReportingStatusInd);
            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);                
                printf("unpack_wds_QueryDLThroughputReportingStatusInd errorCode: %d - %s\n", rtn, helper_get_error_reason(rtn));
            }
            else
            {
	            DisplayQueryDLThroughputReportingStatus(&sQueryDLThroughputReportingStatusInd);
            }
        }            
        break;
    }
    printf (ANSI_COLOR_RESET);
}
