#!/bin/bash

# VERSION 	5.0
# DATE		2022/02/16
# functions for get pci information of SC710.
set -e

source "../bash_functions.sh"
D_DEV_NO=0
D_DEV_INPUT_HDMI=0
D_DEV_INPUT_DVI=1
D_DEV_INPUT_SDI=4
D_DEV_INPUT=${D_DEV_INPUT_HDMI}
D_LOCK=0
D_FRAMERATE=0
D_DRIVER_NAME=""
D_DRIVER_VER=""
D_WIDTH=0
D_HEIGHT=0
D_FORMAT=""
D_FORMAT_GST=""
D_NUM_BUFFER=300
#Interlaced
D_FIELD=""
D_FN=""



STR_BRIDGE=""
STR_BID=""
STR_CHANNEL=""
S_FILTER=""
S_DEV_ID=""
S_TEMP=""

# https://linuxhint.com/bash_split_examples/
# https://www.diskinternals.com/linux-reader/bash-if-string-not-empty/
example_split()
{
	#Define the string value
	text="Welcome to LinuxHint"
	
	#if [[ $# -ne 1 ]]; then	
	if [ -n "${1}" ];then
		text=${1}
	fi

	# Set space as the delimiter
	IFS=' '

	#Read the split words into an array based on space delimiter
	read -a strarr <<< "$text"

	#Count the total words
	echo "There are ${#strarr[*]} words in the text."

	# Print each value of the array by using the loop
	#for val in "${strarr[@]}";
	#do
	#  printf "$val\n"
	#done

	for (( i=0; i<=${#strarr[*]}; i++ ))
	do
		echo "${i}=${strarr[${i}]}"
		case ${i} in
		3 ) D_DEV_INPUT=${strarr[${i}]} ;;
		6 ) 
			if [ ${strarr[${i}]} == "ok)" ];then
				D_LOCK=1
			else
				D_LOCK=0	
			fi
			;;
		esac
	done

	echo "Signal Input=${D_DEV_INPUT} , Lock=${D_LOCK}"
}

#01.query the input status
get_input()
{
	#run_cmd v4l2-ctl -d 0 -n
	
	#01.Execute command
	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -I)
	#echo "STR_RET=${STR_RET}"
	
	#02.Parse input string
	text=${STR_RET}
	IFS=' '
	read -a strarr <<< "$text"
	for (( i=0; i<=${#strarr[*]}; i++ ))
	do
		#echo "${i}=${strarr[${i}]}"
		case ${i} in
		3 ) D_DEV_INPUT=${strarr[${i}]} ;;
		6 ) 
			if [ ${strarr[${i}]} == "ok)" ];then
				D_LOCK=1
			else
				D_LOCK=0	
			fi
			;;
		esac
	done

	echo "device=${D_DEV_NO}, Input=${D_DEV_INPUT}, Lock=${D_LOCK}"
}

get_resolution()
{
	#01.Execute command
	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -i ${D_DEV_INPUT} -V | grep Width)
	#echo "STR_RET=${STR_RET}"
	
	#02.Parse input string
	text=${STR_RET}
	IFS=' '
	read -a strarr <<< "$text"

	#echo "Parse width and height"
	text2=${strarr[2]}
	IFS='/'
	read -a strarr2 <<< "$text2"
	D_WIDTH=${strarr2[0]}
	D_HEIGHT=${strarr2[1]}
	echo "device=${D_DEV_NO}, WIDTH=${D_WIDTH}, HEIGHT=${D_HEIGHT}"
}

get_field()
{
	#01.Execute command
	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -i ${D_DEV_INPUT} -V | grep Field)
	#echo "STR_RET=${STR_RET}"
	
	#02.Parse input string
	text=${STR_RET}
	IFS=' '
	read -a strarr <<< "$text"
	D_FIELD=${strarr[2]}
	#echo "strarr,0-${strarr[0]},1-${strarr[1]},2-${strarr[2]},3-${strarr[3]},4-${strarr[4]},5-${strarr[5]}"

	echo "device=${D_DEV_NO}, FIELD=${D_FIELD}"
}

#query the framerate
# https://stackoverflow.com/questions/1362298/convert-floating-point-variable-to-integer
# https://unix.stackexchange.com/questions/89712/how-to-convert-floating-point-number-to-integer
get_framerate()
{
	#run_cmd v4l2-ctl -d 0 -n
	
	#01.Execute command
	#STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -P)
	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -i ${D_DEV_INPUT} -P | grep second)
	#echo "STR_RET=${STR_RET}"
	
	#02.Parse input string
	text=${STR_RET}
	IFS=' '
	read -a strarr <<< "$text"
	if [ "${strarr[3]}" == "invalid" ];then
		D_FRAMERATE=1
	else
		#D_FRAMERATE=${strarr[${i}]%.*} 
		D_FRAMERATE=$( printf "%.0f" ${strarr[3]} ) 
	fi

	echo "device=${D_DEV_NO}, framerate=${D_FRAMERATE}"
}

get_driver_info()
{
	#01.driver name
	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -D | grep name)
	#echo "STR_RET=${STR_RET}"

	#02.Parse input string
	text=${STR_RET}
	IFS=' '
	read -a strarr <<< "$text"
	D_DRIVER_NAME=${strarr[3]}

	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} -D | grep version)
	#echo "STR_RET=${STR_RET}"
	text=${STR_RET}
	IFS=' '
	read -a strarr <<< "$text"
	D_DRIVER_VER=${strarr[3]}
	echo "device=${D_DEV_NO}, name=${D_DRIVER_NAME},version=${D_DRIVER_VER}"
}

#
tc_01_get_fps()
{
	echo_title "test case 01 : Get video buffer"
	run_cmd gst-launch-1.0 v4l2src device="/dev/video${D_DEV_NO}" num-buffers=${D_NUM_BUFFER} ! queue ! \
	"video/x-raw, format=(string)${D_FORMAT_GST} , width=(int)${D_WIDTH}, height=(int)${D_HEIGHT}" ! \
	fpsdisplaysink video-sink=fakesink text-overlay=false sync=false -v -e
}

tc_02_display()
{
	echo_title "test case 02 : Display"
	run_cmd gst-launch-1.0 v4l2src device="/dev/video${D_DEV_NO}" num-buffers=${D_NUM_BUFFER} -e ! \
	"video/x-raw, format=(string)${D_FORMAT_GST}, width=(int)${D_WIDTH}, height=(int)${D_HEIGHT}" ! \
	videoconvert ! queue ! \
	tee name=t ! queue ! xvimagesink sync=false t. ! queue ! fpsdisplaysink video-sink=fakesink text-overlay=false  sync=false -v 
}

tc_02_display_overlay()
{
	echo_title "test case 02 : Display"
	run_cmd gst-launch-1.0 v4l2src device="/dev/video${D_DEV_NO}" num-buffers=${D_NUM_BUFFER} -e ! \
	"video/x-raw, format=(string)${D_FORMAT_GST}, width=(int)${D_WIDTH}, height=(int)${D_HEIGHT}" ! \
	textoverlay text="${1}_${D_FORMAT_GST}_${D_WIDTH}x${D_HEIGHT}p${D_FRAMERATE}" valignment=top halignment=left font-desc="Sans, 12" ! \
	timeoverlay halignment=right valignment=bottom ! \
	clockoverlay halignment=left valignment=bottom time-format="%Y/%m/%d %H:%M:%S" ! \
	videoconvert ! queue ! \
	tee name=t ! queue ! xvimagesink sync=false t. ! queue ! fpsdisplaysink video-sink=fakesink text-overlay=false  sync=false -v 
}

tc_03_mplayer()
{
	echo_title "test case 03 : mplayer"
	D_FORMAT_ORG=${D_FORMAT}
	#Rule01. change YUYV to YV12 when size is over  1080p
	#Rule02. change NV12 to YV12 when size is under 1080p
	if (( D_HEIGHT > 1080 ));then
		if [ "${D_FORMAT}" == "YUYV" ];then
			D_FORMAT="YV12"
			D_FORMAT_GST="YV12"
		fi
	else
		if [ "${D_FORMAT}" == "NV12" ];then
			D_FORMAT="YV12"
			D_FORMAT_GST="YV12"
		fi
	fi
	
	#Rule03. field is Interlaced, change to YUY2
	if [ "${D_FIELD}" == "Interlaced" ];then
		D_FORMAT="YUYV"
		D_FORMAT_GST="YUY2"	
	fi

	D_FN="${D_FORMAT_ORG}_to_${D_FORMAT}_${D_WIDTH}x${D_HEIGHT}p_${D_FRAMERATE}_${D_FIELD}"
	run_cmd v4l2-ctl -d ${D_DEV_NO} -i ${D_DEV_INPUT} --set-fmt-video=pixelformat=${D_FORMAT},width=${D_WIDTH},height=${D_HEIGHT} -p ${D_FRAMERATE}
	sleep 2
	run_cmd mplayer tv:// -tv driver=v4l2:device=/dev/video${D_DEV_NO}:width=${D_WIDTH}:height=${D_HEIGHT}:fps=${D_FRAMERATE}:outfmt=${D_FORMAT_GST}:normid=4:noaudio -frames 6 -vo jpeg && mv 00000006.jpg ${D_FN}.jpeg && rm -f 0000000*
 
}

tc_04_save_bmp()
{
	echo_title "test case 04 : Save to bmp"
	if [ "${D_FIELD}" == "Interlaced" ];then
		D_FN="${1}_${D_FORMAT}_${D_WIDTH}x${D_HEIGHT}p${D_FRAMERATE}_${D_FIELD}.bmp"
	else
		D_FN="${1}_${D_FORMAT}_${D_WIDTH}x${D_HEIGHT}p${D_FRAMERATE}.bmp"
	fi
	
	run_cmd gst-launch-1.0 v4l2src device="/dev/video${D_DEV_NO}" num-buffers=1 -e ! \
	"video/x-raw, format=(string)${D_FORMAT_GST}, width=(int)${D_WIDTH}, height=(int)${D_HEIGHT}" ! \
	textoverlay text="${1}_${D_FORMAT_GST}_${D_WIDTH}x${D_HEIGHT}p${D_FRAMERATE}" valignment=top halignment=left font-desc="Sans, 12" ! \
	timeoverlay halignment=right valignment=bottom ! \
	clockoverlay halignment=left valignment=bottom time-format="%Y/%m/%d %H:%M:%S" ! \
	videoconvert ! \
	"video/x-raw, width=(int)${D_WIDTH}, height=(int)${D_HEIGHT}, format=(string)BGRA" ! \
	avenc_bmp ! filesink location=${D_FN} -v
}

# https://stackoverflow.com/questions/19771965/split-bash-string-by-newline-characters
test_cases()
{
	n_idx_pfmt=0 
	#01.query supported pixel formats
	STR_RET=$(v4l2-ctl -d ${D_DEV_NO} --list-formats)
#	echo "STR_RET=${STR_RET}"

	#echo "===================================================="
	text="${STR_RET}"
	#read -a strarr <<< "$text"
	readarray -t strarr <<< "$text"
	
	for (( i=0; i<=${#strarr[*]}; i++ ))
	do
		#echo "i.${i}=${strarr[${i}]}"
		#echo "**************************************************"
		text2="${strarr[${i}]}"

		IFS="'"
		read -a strarr2 <<< "$text2"
		D_FORMAT="${strarr2[1]}"
		LEN=${#D_FORMAT} 			
		
		D_FORMAT_GST=""
		case "${D_FORMAT}" in
		"YUYV" ) D_FORMAT_GST="YUY2";;
		"NV12" ) D_FORMAT_GST="NV12";;
		"YV12" ) D_FORMAT_GST="YV12";;
		"YU12" ) D_FORMAT_GST="I420";;
		esac
		
		if [ -n "${D_FORMAT_GST}" ];then
			echo_title  "[${n_idx_pfmt}]-Device=${D_DEV_NO},Input=${D_DEV_INPUT}.Pixel format=${D_FORMAT},Width=${D_WIDTH},Height=${D_HEIGHT},Framerate=${D_FRAMERATE}"
			run_cmd v4l2-ctl -d ${D_DEV_NO} -i ${D_DEV_INPUT} --set-fmt-video=pixelformat=${D_FORMAT},width=${D_WIDTH},height=${D_HEIGHT} -p ${D_FRAMERATE}
			#tc_01_get_fps
			#tc_02_display
			#tc_02_display_overlay ${n_idx_pfmt}
			#tc_03_mplayer
			tc_04_save_bmp ${n_idx_pfmt}
			n_idx_pfmt=$((n_idx_pfmt + 1))
		fi
		# print 2nd array
		#for (( j=0; j<=${#strarr2[*]}; j++ ))
		#do
		#	D_FORMAT_GST="${strarr2[${j}]}"
		#	LEN=${#D_FORMAT_GST} 			
		#	echo "j.${j}=${strarr2[${j}]},length=${LEN}"
		#	
		#	if [ "${D_FORMAT_GST}" == 'YUYV' ];then
		#		echo "Get YUYV"
		#	fi
		#done
		
		# empty array2
		unset strarr2
		#echo "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
		
	done
}

get_parameters()
{
	get_driver_info
	get_input
	get_resolution
	get_field
	get_framerate
}

main_pixel()
{
	if [ -z ${1} ];then
		echo "Please input the index of video device which you want to test"
		echo "For example, to test /dev/video0 : ./test_pixel_formats.sh 0"
		exit
	fi
	D_DEV_NO=${1}
	
	get_parameters
	if [ ${D_LOCK} == "0" ];then
		echo "/dev/device${D_DEV_NO} is no signal"
		exit
	fi
	
	test_cases
	
	#example_split
}

get_bridge_info()
{
	STR_BRIDGE=$(lspci | grep "PCI bridge: Pericom Semiconductor")
	#echo ${STR_BRIDGE}
	text=${STR_BRIDGE}

	#IFS=$'\n'
	readarray -t strarr <<< "$text"
	
	#read -a strarr <<< "$text"
	for (( i=0; i<${#strarr[*]}; i++ ))
	do
		#echo "${i}=${strarr[${i}]}"
		STR_BID=$(echo ${strarr[${i}]} | cut -d ' ' -f 1) 
		echo_title ${STR_BID}
		run_cmd lspci -s ${STR_BID} -vvv | grep Width	
	done

	#echo "device=${D_DEV_NO}, Input=${D_DEV_INPUT}, Lock=${D_LOCK}"

}

get_channel_info()
{
	STR_CHANNEL=$(lspci | grep "YUAN")
	#echo ${STR_BRIDGE}
	text=${STR_CHANNEL}

	readarray -t strarr <<< "$text"
	for (( i=0; i<${#strarr[*]}; i++ ))
	do
		echo "${i}=${strarr[${i}]}"
		#STR_BID=$(echo ${strarr[${i}]} | cut -d ' ' -f 1) 
		#echo_title ${STR_BID}
		#run_cmd lspci -s ${STR_BID} -vvv | grep Width	
	done

	#echo "device=${D_DEV_NO}, Input=${D_DEV_INPUT}, Lock=${D_LOCK}"

}

get_pci_width()
{
	S_FILTER=$(lspci | grep "${1}")
	#echo ${STR_BRIDGE}
	text=${S_FILTER}

	#IFS=$'\n'
	readarray -t strarr <<< "$text"
	
	#read -a strarr <<< "$text"
	for (( i=0; i<${#strarr[*]}; i++ ))
	do
		#echo "${i}=${strarr[${i}]}"
		S_DEV_ID=$(echo ${strarr[${i}]} | cut -d ' ' -f 1) 
		echo_title ${strarr[${i}]}
		run_cmd lspci -s ${S_DEV_ID} -vvv | grep Width	
	done

	#echo "device=${D_DEV_NO}, Input=${D_DEV_INPUT}, Lock=${D_LOCK}"

}

get_pci_info()
{
	#get_bridge_info
	#get_channel_info
	
	#get_pci_width "PCI bridge: Pericom Semiconductor"
	get_pci_width "YUAN"
}

main()
{
	get_pci_info
}

main $@
