// PropertyDialog.cpp : implementation file
//

#include "stdafx.h"
#include "SC280.h"
#include "PropertyDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropertyDialog dialog

extern VOID SC280_DEBUG( TCHAR * fmt, ... );

CPropertyDialog::CPropertyDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CPropertyDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPropertyDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_hDev = 0xFFFFFFFF;
}


void CPropertyDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropertyDialog)
	DDX_Control(pDX, IDC_SLIDER_SHARPNESS, m_sliderSharpness);
	DDX_Control(pDX, IDC_SLIDER_SATURATION, m_sliderSaturation);
	DDX_Control(pDX, IDC_SLIDER_HUE, m_sliderHue);
	DDX_Control(pDX, IDC_SLIDER_CONTRAST, m_sliderContrast);
	DDX_Control(pDX, IDC_SLIDER_BRIGHTNESS, m_sliderBrightness);
	DDX_Control(pDX, IDC_STATIC_SHARPNESS, m_staticSharpness);
	DDX_Control(pDX, IDC_STATIC_SATURATION, m_staticSaturation);
	DDX_Control(pDX, IDC_STATIC_HUE, m_staticHue);
	DDX_Control(pDX, IDC_STATIC_CONTRAST, m_staticContrast);
	DDX_Control(pDX, IDC_STATIC_BRIGHTNESS, m_staticBrightness);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropertyDialog, CDialog)
	//{{AFX_MSG_MAP(CPropertyDialog)
	ON_WM_DESTROY()
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_BRIGHTNESS, OnReleasedCaptureSliderBrightness)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_CONTRAST, OnReleasedCaptureSliderContrast)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_HUE, OnReleasedCaptureSliderHue)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SATURATION, OnReleasedCaptureSliderSaturation)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SHARPNESS, OnReleasedCaptureSliderSharpness)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_BRIGHTNESS, OnCustomDrawSliderBrightness)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_CONTRAST, OnCustomDrawSliderContrast)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_HUE, OnCustomDrawSliderHue)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_SATURATION, OnCustomDrawSliderSaturation)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_SHARPNESS, OnCustomDrawSliderSharpness)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, OnButtonDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropertyDialog message handlers

void CPropertyDialog::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CPropertyDialog::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CPropertyDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	m_sliderBrightness.SetRange( 0, 255 );

	m_sliderContrast.SetRange( 0, 255 );

	m_sliderHue.SetRange( 0, 255 );

	m_sliderSaturation.SetRange( 0, 255 );

	m_sliderSharpness.SetRange( 0, 255 );

	ULONG n_property_value = 0;

	CString str;

	AMESDK_GET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000000, &n_property_value ); str.Format( "%3d", n_property_value ); m_staticBrightness.SetWindowText( str ); m_sliderBrightness.SetPos( n_property_value );

	AMESDK_GET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000001, &n_property_value ); str.Format( "%3d", n_property_value ); m_staticContrast.SetWindowText(   str ); m_sliderContrast.SetPos(   n_property_value );

	AMESDK_GET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000002, &n_property_value ); str.Format( "%3d", n_property_value ); m_staticHue.SetWindowText(        str ); m_sliderHue.SetPos(        n_property_value );

	AMESDK_GET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000003, &n_property_value ); str.Format( "%3d", n_property_value ); m_staticSaturation.SetWindowText( str ); m_sliderSaturation.SetPos( n_property_value );

	AMESDK_GET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000004, &n_property_value ); str.Format( "%3d", n_property_value ); m_staticSharpness.SetWindowText(  str ); m_sliderSharpness.SetPos(  n_property_value );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropertyDialog::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

void CPropertyDialog::OnReleasedCaptureSliderBrightness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderBrightness.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticBrightness.SetWindowText( str ); 

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000000, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnCustomDrawSliderBrightness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
		
	ULONG n_property_value = m_sliderBrightness.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticBrightness.SetWindowText( str ); 

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000000, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnReleasedCaptureSliderContrast(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderContrast.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticContrast.SetWindowText( str ); 

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000001, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnCustomDrawSliderContrast(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	ULONG n_property_value = m_sliderContrast.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticContrast.SetWindowText( str ); 

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000001, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnReleasedCaptureSliderHue(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderHue.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticHue.SetWindowText( str ); 
	
	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000002, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnCustomDrawSliderHue(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderHue.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticHue.SetWindowText( str ); 
	
	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000002, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnReleasedCaptureSliderSaturation(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderSaturation.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticSaturation.SetWindowText( str ); 
	
	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000003, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnCustomDrawSliderSaturation(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderSaturation.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticSaturation.SetWindowText( str ); 
	
	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000003, n_property_value );
	
	*pResult = 0;
}

void CPropertyDialog::OnReleasedCaptureSliderSharpness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderSharpness.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticSharpness.SetWindowText( str ); 
	
	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000004, n_property_value );

	*pResult = 0;
}

void CPropertyDialog::OnCustomDrawSliderSharpness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	ULONG n_property_value = m_sliderSharpness.GetPos();

	CString str; str.Format( "%3d", n_property_value ); 
	
	m_staticSharpness.SetWindowText( str ); 
	
	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000004, n_property_value );
	
	*pResult = 0;
}

void CPropertyDialog::OnButtonDefault() 
{
	// TODO: Add your control notification handler code here

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000000, 128 ); m_staticBrightness.SetWindowText( "128" ); m_sliderBrightness.SetPos( 128 );

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000001, 128 ); m_staticContrast.SetWindowText(   "128" ); m_sliderContrast.SetPos(   128 );

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000002, 128 ); m_staticHue.SetWindowText(        "128" ); m_sliderHue.SetPos(        128 );

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000003, 128 ); m_staticSaturation.SetWindowText( "128" ); m_sliderSaturation.SetPos( 128 );

	AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hDev, 0x00000004, 128 ); m_staticSharpness.SetWindowText(  "128" ); m_sliderSharpness.SetPos(  128 );
}
