// StreamCatcherDemoDlg.h : header file
//

#if !defined(AFX_STREAMCATCHERDEMODLG_H__D27D4F56_AD1E_4DD2_86DE_8EBC60B357DF__INCLUDED_)
#define AFX_STREAMCATCHERDEMODLG_H__D27D4F56_AD1E_4DD2_86DE_8EBC60B357DF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CStreamCatcherDemoDlg dialog

#include "ChannelWindow.h"

#include "SetupDlg.h"

class CStreamCatcherDemoDlg : public CDialog
{
// Construction
public:
	CStreamCatcherDemoDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CStreamCatcherDemoDlg)
	enum { IDD = IDD_STREAMCATCHERDEMO_DIALOG };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStreamCatcherDemoDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CStreamCatcherDemoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	BOOL				OnLButtonDblClk_ChannelWindow();

	BOOL				OnButtonVideoInput_SetupDialog();

	BOOL				OnButtonAudioInput_SetupDialog();

	BOOL				OnButtonVideoQuality_SetupDialog();

	BOOL				OnButtonSnapshot_SetupDialog();

	BOOL				OnButtonRecordStart_SetupDialog();

	BOOL				OnButtonRecordStop_SetupDialog();

	BOOL				OnCheckGpuSupport_SetupDialog();

	BOOL				OnCheckAutoDeinterlace_SetupDialog();

	BOOL				OnCheckAutoPhase_SetupDialog();

	BOOL				OnChangeEditAutoPhase_SetupDialog();

	BOOL				OnGetDeviceFormatInfomation( ULONG * pVideoWidth, ULONG * pVideoHeight, BOOL * pVideoIsInterleaved, ULONG * pVideoFrameRate, ULONG * pAudioChannels, ULONG * pAudioBitsPerSample, ULONG * pAudioSampleFrequency );

	BOOL				HwUninitialize();

	BOOL				HwInitialize();

	CChannelWindow		m_oChannelWindows[ 2 ];

	CSetupDlg			m_oSetupDialog;

	HANDLE				m_hDeviceInitializeThread;

	ULONG				m_hDeviceInitializeThreadNumber;

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// VIDEO PROPERTIES

	DEVICE_HANDLE		m_hVideoDevice;

	DEVICE_HANDLE		m_hVideoSoftwareEncoderDevice;

	DEVICE_HANDLE		m_hVideoSoftwareDeinterlacerDevice;

	ULONG				m_nVideoWidth;

	ULONG				m_nVideoHeight;

	BOOL				m_bVideoIsInterleaved;

	ULONG				m_nVideoFrameRate;

	BOOL				m_bVideoDeinterlaceEnable;

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// AUDIO PROPERTIES

	DEVICE_HANDLE		m_hAudioDevice;

	ULONG				m_nAudioChannels;

	ULONG				m_nAudioBitsPerSample;

	ULONG				m_nAudioSampleFrequency;

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// RECORD & FILE PROPERTIES
	
	CString				m_strDefaultPath;

	CString				m_strSnapshotPath;

	CString				m_strRecordPath;

	CString				m_strRecordFileName;

	volatile ULONG		m_nRecordState;

	DEVICE_HANDLE		m_hDevFileRenderer;

	CRITICAL_SECTION	m_hFileRendererAccessCriticalSection;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_STREAMCATCHERDEMODLG_H__D27D4F56_AD1E_4DD2_86DE_8EBC60B357DF__INCLUDED_)
