// LivePropertyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "MultiRecoderDemoDlg.h"
#include "LivePropertyDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLivePropertyDlg dialog


CLivePropertyDlg::CLivePropertyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLivePropertyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLivePropertyDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CLivePropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLivePropertyDlg)
	DDX_Control(pDX, IDC_TAB_LIVE, m_tabLive);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLivePropertyDlg, CDialog)
	//{{AFX_MSG_MAP(CLivePropertyDlg)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_LIVE, OnSelchangeTabLive)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLivePropertyDlg message handlers

BOOL CLivePropertyDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	// CREATE AND MAINTAIN THEIR LAYOUT
	//
	CRect oWindowRect; GetWindowRect( &oWindowRect );

	CRect oClientRect; GetClientRect( &oClientRect );

	ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	ULONG tx = 10;												// SET CUSTOM BOUNDARY WIDTH OF TAB CONTROL

	ULONG ty = 32;												// SET CUSTOM BOUNDARY HEIGHT OF TAB CONTROL

	SetWindowPos( &(CWnd::wndTop), 0, 0, 640 + cx + (tx + tx) , 720 + cy + (ty + tx), SWP_NOMOVE );

	m_tabLive.MoveWindow( 0, 0, 640 + (tx + tx), 720 + (ty + tx) );		

	m_tabLive.InsertItem( 0, "VIDEO INPUT" );

	m_tabLive.InsertItem( 1, "AUDIO INPUT" );

	m_tabLive.InsertItem( 2, "RECORDING" );

	m_tabLive.InsertItem( 3, "SNASHOP" );

	m_tabLive.InsertItem( 4, "OSD" );

	// CONNECT WITH VIDEO INPUT PANEL
	//
	m_oVideoInputPanel.Create( IDD_DIALOG_VIDEO_INPUT, GetDlgItem( IDC_TAB_LIVE ) );		

	CRect oTabClientRect; m_tabLive.GetClientRect( &oTabClientRect );

	oTabClientRect.top += 27;

	oTabClientRect.bottom -= 10;

	oTabClientRect.left += 10;

	oTabClientRect.right -= 10;
				
	m_oVideoInputPanel.MoveWindow( &oTabClientRect );								// SET CTRL DIALOG LOCATION
		
	// CONNECT WITH AUDIO INPUT PANEL
	//
	m_oAudioInputPanel.Create( IDD_DIALOG_AUDIO_INPUT, GetDlgItem( IDC_TAB_LIVE ) );		

	m_oAudioInputPanel.MoveWindow( &oTabClientRect );								// SET CTRL DIALOG LOCATION		

	// CONNECT WITH RECORD PANEL
	//
	m_oRecordPanel.Create( IDD_DIALOG_RECORD, GetDlgItem( IDC_TAB_LIVE ) );		

	m_oRecordPanel.MoveWindow( &oTabClientRect );									// SET CTRL DIALOG LOCATION		

	// CONNECT WITH SNAPSHOT PANEL
	//
	m_oSnapshotPanel.Create( IDD_DIALOG_SNAPSHOT, GetDlgItem( IDC_TAB_LIVE ) );		

	m_oSnapshotPanel.MoveWindow( &oTabClientRect );									// SET CTRL DIALOG LOCATION		

	// CONNECT WITH OSD PANEL
	//
	m_oOnScreenDisplayPanel.Create( IDD_DIALOG_OSD, GetDlgItem( IDC_TAB_LIVE ) );		

	m_oOnScreenDisplayPanel.MoveWindow( &oTabClientRect );									// SET CTRL DIALOG LOCATION
		
	//	ACCORDING TO PREVIOUS PROPERTY SETTING AND PAGE NUMBER
	//
	m_tabLive.SetCurSel( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] );

	if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 0 ) { 
		
		m_oVideoInputPanel.ShowWindow( 1 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 1 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 1 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 2 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 1 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 3 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 1 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 4 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 1 );
	}	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLivePropertyDlg::OnSelchangeTabLive(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] = m_tabLive.GetCurSel();


	if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 0 ) { 
		
		m_oVideoInputPanel.ShowWindow( 1 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 1 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 1 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 2 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 1 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 3 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 1 );

		m_oOnScreenDisplayPanel.ShowWindow( 0 );
	}
	else if ( pMainDlg->m_nLiveTabPage[ m_nLiveChannelNum ] == 4 ) { 
		
		m_oVideoInputPanel.ShowWindow( 0 );

		m_oAudioInputPanel.ShowWindow( 0 );

		m_oRecordPanel.ShowWindow( 0 );

		m_oSnapshotPanel.ShowWindow( 0 );

		m_oOnScreenDisplayPanel.ShowWindow( 1 );
	}

	*pResult = 0;
}
